/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    private static final Log log = LogFactory.getLog(HttpUtils.class);
    private static final int BUFFER_SIZE = 0x200000;

    private HttpUtils() {
    }

    public static Response invokeGET(UrlBuilder url, BindingSession session) {
        return HttpUtils.invoke(url, "GET", null, null, null, session, null, null);
    }

    public static Response invokeGET(UrlBuilder url, BindingSession session, BigInteger offset, BigInteger length) {
        return HttpUtils.invoke(url, "GET", null, null, null, session, offset, length);
    }

    public static Response invokePOST(UrlBuilder url, String contentType, Output writer, BindingSession session) {
        return HttpUtils.invoke(url, "POST", contentType, null, writer, session, null, null);
    }

    public static Response invokePUT(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, BindingSession session) {
        return HttpUtils.invoke(url, "PUT", contentType, headers, writer, session, null, null);
    }

    public static Response invokeDELETE(UrlBuilder url, BindingSession session) {
        return HttpUtils.invoke(url, "DELETE", null, null, null, session, null, null);
    }

    private static Response invoke(UrlBuilder url, String method, String contentType, Map<String, String> headers, Output writer, BindingSession session, BigInteger offset, BigInteger length) {
        try {
            Object compression;
            Map httpHeaders;
            AuthenticationProvider authProvider;
            int readTimeout;
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + " " + url));
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(url.toString()).openConnection();
            conn.setRequestMethod(method);
            conn.setDoInput(true);
            conn.setDoOutput(writer != null);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(false);
            conn.setRequestProperty("User-Agent", ClientVersion.OPENCMIS_CLIENT);
            int connectTimeout = session.get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                conn.setConnectTimeout(connectTimeout);
            }
            if ((readTimeout = session.get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                conn.setReadTimeout(readTimeout);
            }
            if (contentType != null) {
                conn.setRequestProperty("Content-Type", contentType);
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    conn.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            if ((authProvider = CmisBindingsHelper.getAuthenticationProvider(session)) != null && (httpHeaders = authProvider.getHTTPHeaders(url.toString())) != null) {
                for (Map.Entry header : httpHeaders.entrySet()) {
                    if (header.getValue() == null) continue;
                    for (String value : (List)header.getValue()) {
                        conn.setRequestProperty((String)header.getKey(), value);
                    }
                }
            }
            if (offset != null || length != null) {
                StringBuilder sb = new StringBuilder("bytes=");
                if (offset == null || offset.signum() == -1) {
                    offset = BigInteger.ZERO;
                }
                sb.append(offset.toString());
                sb.append("-");
                if (length != null && length.signum() == 1) {
                    sb.append(offset.add(length.subtract(BigInteger.ONE)).toString());
                }
                conn.setRequestProperty("Range", sb.toString());
            }
            if ((compression = session.get("org.apache.chemistry.opencmis.binding.compression")) != null && Boolean.parseBoolean(compression.toString())) {
                conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            }
            if (session.get("org.apache.chemistry.opencmis.binding.acceptLanguage") instanceof String) {
                conn.setRequestProperty("Accept-Language", session.get("org.apache.chemistry.opencmis.binding.acceptLanguage").toString());
            }
            if (writer != null) {
                conn.setChunkedStreamingMode(65536);
                OutputStream connOut = null;
                Object clientCompression = session.get("org.apache.chemistry.opencmis.binding.clientcompression");
                if (clientCompression != null && Boolean.parseBoolean(clientCompression.toString())) {
                    conn.setRequestProperty("Content-Encoding", "gzip");
                    connOut = new GZIPOutputStream(conn.getOutputStream(), 4096);
                } else {
                    connOut = conn.getOutputStream();
                }
                BufferedOutputStream out = new BufferedOutputStream(connOut, 0x200000);
                writer.write(out);
                ((OutputStream)out).flush();
            }
            conn.connect();
            int respCode = conn.getResponseCode();
            InputStream inputStream = null;
            if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 206) {
                inputStream = conn.getInputStream();
            }
            if (authProvider != null) {
                authProvider.putResponseHeaders(url.toString(), respCode, conn.getHeaderFields());
            }
            return new Response(respCode, conn.getResponseMessage(), conn.getHeaderFields(), inputStream, conn.getErrorStream());
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot access " + url + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static interface Output {
        public void write(OutputStream var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response {
        private final int responseCode;
        private final String responseMessage;
        private final Map<String, List<String>> headers;
        private InputStream stream;
        private String errorContent;
        private BigInteger length;

        public Response(int responseCode, String responseMessage, Map<String, List<String>> headers, InputStream responseStream, InputStream errorStream) {
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.stream = responseStream;
            this.headers = new HashMap<String, List<String>>();
            if (headers != null) {
                for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                    this.headers.put(e.getKey() == null ? null : e.getKey().toLowerCase(), e.getValue());
                }
            }
            if (errorStream != null) {
                String contentType = this.getContentTypeHeader();
                if (contentType != null) {
                    String contentTypeLower = contentType.toLowerCase().split(";")[0];
                    if (contentTypeLower.startsWith("text/") || contentTypeLower.endsWith("+xml")) {
                        StringBuilder sb = new StringBuilder();
                        try {
                            int b;
                            String encoding = this.getContentEncoding();
                            if (encoding != null) {
                                if (encoding.toLowerCase().trim().equals("gzip")) {
                                    try {
                                        errorStream = new GZIPInputStream(errorStream, 4096);
                                    }
                                    catch (IOException e) {}
                                } else if (encoding.toLowerCase().trim().equals("deflate")) {
                                    errorStream = new InflaterInputStream(errorStream, new Inflater(true), 4096);
                                }
                            }
                            InputStreamReader reader = new InputStreamReader(errorStream);
                            char[] buffer = new char[4096];
                            while ((b = reader.read(buffer)) > -1) {
                                sb.append(buffer, 0, b);
                            }
                            reader.close();
                            this.errorContent = sb.toString();
                        }
                        catch (IOException e) {
                            this.errorContent = "Unable to retrieve content: " + e.getMessage();
                        }
                    }
                } else {
                    try {
                        errorStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (responseStream != null) {
                    try {
                        responseStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return;
            }
            String lengthStr = this.getHeader("Content-Length");
            if (lengthStr != null) {
                try {
                    this.length = new BigInteger(lengthStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (this.stream != null) {
                String encoding = this.getContentEncoding();
                if (encoding != null) {
                    if (encoding.toLowerCase().trim().equals("gzip")) {
                        this.length = null;
                        try {
                            this.stream = new GZIPInputStream(this.stream, 4096);
                        }
                        catch (IOException e) {
                            this.errorContent = e.getMessage();
                            this.stream = null;
                            try {
                                responseStream.close();
                            }
                            catch (IOException ec) {}
                        }
                    } else if (encoding.toLowerCase().trim().equals("deflate")) {
                        this.length = null;
                        this.stream = new InflaterInputStream(this.stream, new Inflater(true), 4096);
                    }
                }
                String transferEncoding = this.getContentTransferEncoding();
                if (this.stream != null && transferEncoding != null && transferEncoding.toLowerCase().trim().equals("base64")) {
                    this.length = null;
                    this.stream = new Base64.InputStream(this.stream);
                }
            }
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getHeader(String name) {
            List<String> list = this.headers.get(name.toLowerCase(Locale.US));
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }

        public String getContentTypeHeader() {
            return this.getHeader("Content-Type");
        }

        public BigInteger getContentLengthHeader() {
            String lengthStr = this.getHeader("Content-Length");
            if (lengthStr == null) {
                return null;
            }
            try {
                return new BigInteger(lengthStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public String getLocactionHeader() {
            return this.getHeader("Location");
        }

        public String getContentLocactionHeader() {
            return this.getHeader("Content-Location");
        }

        public String getContentTransferEncoding() {
            return this.getHeader("Content-Transfer-Encoding");
        }

        public String getContentEncoding() {
            return this.getHeader("Content-Encoding");
        }

        public BigInteger getContentLength() {
            return this.length;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String getErrorContent() {
            return this.errorContent;
        }
    }
}

