/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;

public class NuxeoTypeHelper {
    private static final Log log = LogFactory.getLog(NuxeoTypeHelper.class);
    public static final String NUXEO_DOCUMENT = "Document";
    public static final String NUXEO_FOLDER = "Folder";
    public static final String NUXEO_RELATION = "Relation";
    public static final String NUXEO_FILE = "File";
    public static final String NUXEO_ORDERED_FOLDER = "OrderedFolder";
    public static final String NX_DUBLINCORE = "dublincore";
    public static final String NX_DC_TITLE = "dc:title";
    public static final String NX_DC_CREATED = "dc:created";
    public static final String NX_DC_CREATOR = "dc:creator";
    public static final String NX_DC_MODIFIED = "dc:modified";
    public static final String NX_DC_LAST_CONTRIBUTOR = "dc:lastContributor";
    public static final String NX_ICON = "common:icon";
    public static final String NX_REL_SOURCE = "relation:source";
    public static final String NX_REL_TARGET = "relation:target";
    public static final String NX_DIGEST = "nuxeo:contentStreamDigest";
    public static final String NX_ISVERSION = "nuxeo:isVersion";
    public static final String NX_ISCHECKEDIN = "nuxeo:isCheckedIn";
    public static final String NX_FACETS = "nuxeo:secondaryObjectTypeIds";
    public static final String NX_LIFECYCLE_STATE = "nuxeo:lifecycleState";
    private static final String NAMESPACE = "http://ns.nuxeo.org/cmis/type/";
    protected AbstractTypeDefinition t;
    protected Map<String, String> propertyToSchema = new HashMap<String, String>();

    protected NuxeoTypeHelper(String id, String parentId, BaseTypeId baseTypeId, DocumentType documentType, String nuxeoTypeId, boolean creatable) {
        this.constructBase(id, parentId, baseTypeId, documentType, nuxeoTypeId, creatable);
    }

    public static String getParentTypeId(DocumentType documentType) {
        if (documentType.getFacets().contains("HiddenInNavigation") || !documentType.hasSchema(NX_DUBLINCORE)) {
            return null;
        }
        String nuxeoTypeId = documentType.getName();
        if (NUXEO_FOLDER.equals(nuxeoTypeId)) {
            return BaseTypeId.CMIS_FOLDER.value();
        }
        if (NUXEO_RELATION.equals(nuxeoTypeId)) {
            return BaseTypeId.CMIS_RELATIONSHIP.value();
        }
        DocumentType superType = (DocumentType)documentType.getSuperType();
        if (superType == null) {
            return null;
        }
        String parentId = NuxeoTypeHelper.mappedId(superType.getName());
        if (NUXEO_FOLDER.equals(parentId)) {
            parentId = BaseTypeId.CMIS_FOLDER.value();
        }
        if (NUXEO_RELATION.equals(parentId)) {
            parentId = BaseTypeId.CMIS_RELATIONSHIP.value();
        }
        if (NUXEO_DOCUMENT.equals(parentId)) {
            parentId = BaseTypeId.CMIS_DOCUMENT.value();
        }
        return parentId;
    }

    public static TypeDefinition construct(DocumentType documentType, String parentId) {
        String nuxeoTypeId = documentType.getName();
        String id = NuxeoTypeHelper.mappedId(nuxeoTypeId);
        NuxeoTypeHelper h = new NuxeoTypeHelper(id, parentId, NuxeoTypeHelper.getBaseTypeId(documentType), documentType, nuxeoTypeId, true);
        for (Schema schema : documentType.getSchemas()) {
            h.addSchemaPropertyDefinitions(schema);
        }
        return h.t;
    }

    public static TypeDefinition constructCmisBase(BaseTypeId baseTypeId, SchemaManager schemaManager) {
        NuxeoTypeHelper h = new NuxeoTypeHelper(baseTypeId.value(), null, baseTypeId, null, null, true);
        DocumentType dt = schemaManager.getDocumentType(NUXEO_FOLDER);
        h.addSchemaPropertyDefinitions(dt.getSchema(NX_DUBLINCORE));
        return h.t;
    }

    protected void addSchemaPropertyDefinitions(Schema schema) {
        for (Field field : schema.getFields()) {
            PropertyType propertyType;
            Cardinality cardinality;
            Type fieldType = field.getType();
            String schemaName = schema.getName();
            if (fieldType.isComplexType()) {
                log.debug((Object)("Ignoring complex type: " + schemaName + '/' + field.getName() + " in type: " + this.t.getId()));
                continue;
            }
            if (fieldType.isListType()) {
                Type listFieldType = ((ListType)fieldType).getFieldType();
                if (!listFieldType.isSimpleType()) {
                    log.debug((Object)("Ignoring complex list: " + schemaName + '/' + field.getName() + " in type: " + this.t.getId()));
                    continue;
                }
                cardinality = Cardinality.MULTI;
                propertyType = NuxeoTypeHelper.getPropertType((SimpleType)listFieldType);
            } else {
                cardinality = Cardinality.SINGLE;
                propertyType = NuxeoTypeHelper.getPropertType((SimpleType)fieldType);
            }
            String name = field.getName().getPrefixedName();
            PropertyDefinition<?> pd = NuxeoTypeHelper.newPropertyDefinition(name, name, propertyType, cardinality, Updatability.READWRITE, false, false, true, true);
            if (this.t.getPropertyDefinitions().containsKey(pd.getId())) {
                log.error((Object)("Type '" + this.t.getId() + "' has duplicate property '" + name + "' in schemas '" + this.propertyToSchema.get(pd.getId()) + "' and '" + schemaName + "', ignoring the one in '" + schemaName + "'"));
                continue;
            }
            this.propertyToSchema.put(pd.getId(), schemaName);
            this.t.addPropertyDefinition(pd);
        }
    }

    protected void constructBase(String id, String parentId, BaseTypeId baseTypeId, DocumentType documentType, String nuxeoTypeId, boolean creatable) {
        this.t = baseTypeId == BaseTypeId.CMIS_FOLDER ? new FolderTypeDefinitionImpl() : (baseTypeId == BaseTypeId.CMIS_RELATIONSHIP ? new RelationshipTypeDefinitionImpl() : new DocumentTypeDefinitionImpl());
        this.t.setBaseTypeId(baseTypeId);
        this.t.setId(id);
        this.t.setParentTypeId(parentId);
        this.t.setDescription(id);
        this.t.setDisplayName(id);
        this.t.setLocalName(nuxeoTypeId == null ? id : nuxeoTypeId);
        Namespace ns = documentType == null ? null : documentType.getNamespace();
        this.t.setLocalNamespace(ns == null ? NAMESPACE : ns.uri);
        this.t.setQueryName(id);
        this.t.setIsCreatable(Boolean.valueOf(creatable));
        this.t.setIsQueryable(Boolean.TRUE);
        this.t.setIsIncludedInSupertypeQuery(Boolean.TRUE);
        this.t.setIsFulltextIndexed(Boolean.TRUE);
        this.t.setIsControllableAcl(Boolean.FALSE);
        this.t.setIsControllablePolicy(Boolean.FALSE);
        this.addBasePropertyDefinitions();
        if (this.t instanceof FolderTypeDefinitionImpl) {
            this.t.setIsFileable(Boolean.TRUE);
            FolderTypeDefinitionImpl ft = (FolderTypeDefinitionImpl)this.t;
            NuxeoTypeHelper.addFolderPropertyDefinitions(ft);
        } else if (this.t instanceof RelationshipTypeDefinitionImpl) {
            RelationshipTypeDefinitionImpl rt = (RelationshipTypeDefinitionImpl)this.t;
            rt.setAllowedSourceTypes(null);
            rt.setAllowedTargetTypes(null);
            NuxeoTypeHelper.addRelationshipPropertyDefinitions(rt);
            this.t.setIsFileable(Boolean.FALSE);
        } else {
            DocumentTypeDefinitionImpl dt = (DocumentTypeDefinitionImpl)this.t;
            boolean versionable = documentType == null ? false : documentType.getFacets().contains("Versionable");
            dt.setIsVersionable(Boolean.valueOf(versionable));
            this.t.setIsFileable(Boolean.TRUE);
            ContentStreamAllowed csa = documentType != null && NuxeoTypeHelper.supportsBlobHolder(documentType) ? ContentStreamAllowed.ALLOWED : ContentStreamAllowed.NOTALLOWED;
            dt.setContentStreamAllowed(csa);
            NuxeoTypeHelper.addDocumentPropertyDefinitions(dt);
        }
    }

    protected void addBasePropertyDefinitions() {
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:objectId", "Object ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:objectTypeId", "Type ID", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, false, true, false, false));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:baseTypeId", "Base Type ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:name", "Name", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, false, true, true, true));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:createdBy", "Created By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:creationDate", "Creation Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:lastModifiedBy", "Last Modified By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:lastModificationDate", "Last Modification Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:changeToken", "Change Token", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition(NX_LIFECYCLE_STATE, "Lifecycle State", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        this.t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition(NX_FACETS, "Facets", PropertyType.STRING, Cardinality.MULTI, Updatability.READONLY, true, false, true, false));
    }

    protected static void addFolderPropertyDefinitions(FolderTypeDefinitionImpl t) {
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:parentId", "Parent ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:path", "Path", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:allowedChildObjectTypeIds", "Allowed Child Object Type IDs", PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, false, false, false, false));
    }

    protected static void addRelationshipPropertyDefinitions(RelationshipTypeDefinitionImpl t) {
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:sourceId", "Source ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READWRITE, false, true, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:targetId", "Target ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READWRITE, false, true, true, true));
    }

    protected static void addDocumentPropertyDefinitions(DocumentTypeDefinitionImpl t) {
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isImmutable", "Is Immutable", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isLatestVersion", "Is Latest Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isMajorVersion", "Is Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isLatestMajorVersion", "Is Latest Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionLabel", "Version Label", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionSeriesId", "Version Series ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:isVersionSeriesCheckedOut", "Is Version Series Checked Out", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionSeriesCheckedOutBy", "Version Series Checked Out By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:versionSeriesCheckedOutId", "Version Series Checked Out ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:checkinComment", "Checkin Comment", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamLength", "Content Stream Length", PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamMimeType", "MIME Type", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamFileName", "Filename", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition("cmis:contentStreamId", "Content Stream ID", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition(NX_DIGEST, "Content Stream Digest", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false, false, false));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition(NX_ISVERSION, "Is Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
        t.addPropertyDefinition(NuxeoTypeHelper.newPropertyDefinition(NX_ISCHECKEDIN, "Is Checked In PWC", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false, true, true));
    }

    protected static PropertyDefinition<?> newPropertyDefinition(String id, String displayName, PropertyType propertyType, Cardinality cardinality, Updatability updatability, boolean inherited, boolean required, boolean queryable, boolean orderable) {
        PropertyBooleanDefinitionImpl p;
        switch (propertyType) {
            case BOOLEAN: {
                p = new PropertyBooleanDefinitionImpl();
                break;
            }
            case DATETIME: {
                p = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                p = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                p = new PropertyHtmlDefinitionImpl();
                break;
            }
            case ID: {
                p = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                p = new PropertyIntegerDefinitionImpl();
                break;
            }
            case STRING: {
                p = new PropertyStringDefinitionImpl();
                break;
            }
            case URI: {
                p = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                throw new RuntimeException(propertyType.toString());
            }
        }
        p.setId(id);
        p.setDescription(displayName);
        p.setDisplayName(displayName);
        p.setLocalName(id);
        p.setLocalNamespace(null);
        p.setQueryName(id);
        p.setPropertyType(propertyType);
        p.setCardinality(cardinality);
        p.setUpdatability(updatability);
        p.setIsInherited(Boolean.valueOf(inherited));
        p.setIsRequired(Boolean.valueOf(required));
        p.setIsQueryable(Boolean.valueOf(queryable));
        p.setIsOrderable(Boolean.valueOf(orderable));
        return p;
    }

    protected static boolean supportsBlobHolder(DocumentType documentType) {
        DocumentModelImpl doc = new DocumentModelImpl(null, documentType.getName(), null, new Path("/"), null, null, null, documentType.getSchemaNames(), documentType.getFacets(), null, "default");
        return doc.getAdapter(BlobHolder.class) != null;
    }

    protected static String mappedId(String id) {
        return id;
    }

    protected static PropertyType getPropertType(SimpleType type) {
        SimpleType primitive = type.getPrimitiveType();
        if (primitive == StringType.INSTANCE) {
            return PropertyType.STRING;
        }
        if (primitive == BooleanType.INSTANCE) {
            return PropertyType.BOOLEAN;
        }
        if (primitive == DateType.INSTANCE) {
            return PropertyType.DATETIME;
        }
        if (primitive == LongType.INSTANCE) {
            return PropertyType.INTEGER;
        }
        if (primitive == DoubleType.INSTANCE) {
            return PropertyType.DECIMAL;
        }
        return PropertyType.STRING;
    }

    public static BaseTypeId getBaseTypeId(DocumentType type) {
        if (type.isFolder()) {
            return BaseTypeId.CMIS_FOLDER;
        }
        DocumentType t = type;
        do {
            if (!NUXEO_RELATION.equals(t.getName())) continue;
            return BaseTypeId.CMIS_RELATIONSHIP;
        } while ((t = (DocumentType)t.getSuperType()) != null);
        return BaseTypeId.CMIS_DOCUMENT;
    }

    public static BaseTypeId getBaseTypeId(DocumentModel doc) {
        return NuxeoTypeHelper.getBaseTypeId(doc.getDocumentType());
    }
}

