/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.service;

import java.io.IOException;
import java.util.List;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.fake.UnregistredFakeConnector;
import org.nuxeo.connect.connector.http.ConnectHttpConnector;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.downloads.ConnectDownloadManagerImpl;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.registration.RegistrationHelper;

public class ConnectGatewayComponent
implements ConnectRegistrationService {
    protected ConnectConnector connector = null;
    protected ConnectDownloadManager downloadManager = null;
    public static ConnectConnector testConnector = null;
    protected TechnicalInstanceIdentifier ctid = new TechnicalInstanceIdentifier();

    @Override
    public TechnicalInstanceIdentifier getCTID() {
        return this.ctid;
    }

    @Override
    public LogicalInstanceIdentifier getCLID() {
        try {
            return LogicalInstanceIdentifier.instance();
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            return null;
        }
    }

    @Override
    public void localRegisterInstance(String strCLID, String description) throws LogicalInstanceIdentifier.InvalidCLID, IOException {
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier(strCLID, description);
        CLID.save();
        this.connector = null;
    }

    @Override
    public boolean isInstanceRegistred() {
        try {
            LogicalInstanceIdentifier.instance();
            return true;
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            return false;
        }
    }

    @Override
    public ConnectConnector getConnector() {
        if (NuxeoConnectClient.isTestModeSet() && testConnector != null) {
            return testConnector;
        }
        if (this.connector == null) {
            this.connector = this.isInstanceRegistred() ? new ConnectHttpConnector() : new UnregistredFakeConnector();
        }
        return this.connector;
    }

    public ConnectDownloadManager getDownloadManager() {
        if (this.downloadManager == null) {
            this.downloadManager = new ConnectDownloadManagerImpl();
        }
        return this.downloadManager;
    }

    @Override
    public List<ConnectProject> getAvailableProjectsForRegistration(String login, String password) throws Exception {
        return RegistrationHelper.getAvailableProjectsForRegistration(login, password);
    }

    @Override
    public void remoteRegisterInstance(String login, String password, String prjId, NuxeoClientInstanceType type, String description) throws Exception {
        String strCLID = RegistrationHelper.remoteRegisterInstance(login, password, prjId, type, description);
        if (strCLID != null) {
            this.localRegisterInstance(strCLID, description);
        }
    }
}

