/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.deployment.NuxeoStarter;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PackWar {
    private static final List<String> MISSING_LIBS = Arrays.asList("commons-logging", "commons-lang", "log4j", "mail", "freemarker");
    private static Log log = LogFactory.getLog(PackWar.class);
    private static final String COMMAND_PREPROCESSING = "preprocessing";
    private static final String COMMAND_PACKAGING = "packaging";
    protected File nxserver;
    protected File war;

    public PackWar(File nxserver, File war) {
        if (!nxserver.isDirectory() || !nxserver.getName().equals("nxserver")) {
            PackWar.fail("No nxserver found at " + nxserver);
        }
        if (war.exists()) {
            PackWar.fail("Target WAR file " + war + " already exists");
        }
        this.nxserver = nxserver;
        this.war = war;
    }

    public void execute(String command) throws Exception {
        boolean packaging;
        boolean preprocessing = COMMAND_PREPROCESSING.equals(command) || StringUtils.isBlank((String)command);
        boolean bl = packaging = COMMAND_PACKAGING.equals(command) || StringUtils.isBlank((String)command);
        if (!preprocessing && !packaging) {
            PackWar.fail("Command parameter should be empty or preprocessing or packaging");
        }
        if (preprocessing) {
            this.executePreprocessing();
        }
        if (packaging) {
            this.executePackaging();
        }
    }

    protected void executePreprocessing() throws Exception {
        this.runTemplatePreprocessor();
        this.runDeploymentPreprocessor();
    }

    protected void runTemplatePreprocessor() throws Exception {
        System.setProperty("nuxeo.home", this.nxserver.getPath());
        System.setProperty("nuxeo.conf", new File(this.nxserver, "config").getPath());
        new ConfigurationGenerator().run();
    }

    protected void runDeploymentPreprocessor() throws Exception {
        DeploymentPreprocessor processor = new DeploymentPreprocessor(this.nxserver);
        processor.init();
        processor.predeploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePackaging() throws IOException {
        FileOutputStream out = new FileOutputStream(this.war);
        ZipOutputStream zout = new ZipOutputStream(out);
        try {
            String webInfDir = "WEB-INF/";
            String webInfLibDir = webInfDir + "lib/";
            this.zipTree("", new File(this.nxserver, "nuxeo.war"), false, zout);
            this.zipTree(webInfDir, new File(this.nxserver, "config"), false, zout);
            this.zipTree(webInfLibDir, new File(this.nxserver, "bundles"), false, zout);
            this.zipTree(webInfLibDir, new File(this.nxserver, "lib"), false, zout);
            File lib = new File(this.nxserver.getParent(), "lib");
            block3: for (String name : lib.list()) {
                for (String pat : MISSING_LIBS) {
                    String prefix = pat + '-';
                    if (!name.startsWith(prefix) || !name.endsWith(".jar") || !Character.isDigit(name.charAt(prefix.length()))) continue;
                    this.zipFile(new File(lib, name), webInfLibDir + name, zout, null);
                    continue block3;
                }
            }
        }
        finally {
            if (zout != null) {
                zout.finish();
                zout.close();
            }
        }
    }

    protected void zipDirectory(String entryName, ZipOutputStream zout) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        zout.putNextEntry(zentry);
        zout.closeEntry();
    }

    protected void zipFile(File file, String entryName, ZipOutputStream zout, FileProcessor processor) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        if (processor == null) {
            processor = CopyProcessor.INSTANCE;
            zentry.setTime(file.lastModified());
        }
        zout.putNextEntry(zentry);
        processor.process(file, zout);
        zout.closeEntry();
    }

    protected void zipTree(String prefix, File root, boolean includeRoot, ZipOutputStream zout) throws IOException {
        if (includeRoot) {
            prefix = prefix + root.getName() + '/';
            this.zipDirectory(prefix, zout);
        }
        for (String name : root.list()) {
            File file = new File(root, name);
            if (file.isDirectory()) {
                this.zipTree(prefix, file, true, zout);
                continue;
            }
            if (name.endsWith("~") || name.endsWith("#") || name.endsWith(".bak") || name.equals("README.txt")) continue;
            name = prefix + name;
            WebXmlProcessor processor = name.equals("WEB-INF/web.xml") ? WebXmlProcessor.INSTANCE : null;
            this.zipFile(file, name, zout, processor);
        }
    }

    public static void fail(String message) {
        PackWar.fail(message, null);
    }

    public static void fail(String message, Throwable t) {
        log.error((Object)message, t);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3 || args.length == 3 && !Arrays.asList(COMMAND_PREPROCESSING, COMMAND_PACKAGING).contains(args[2])) {
            PackWar.fail(String.format("Usage: %s <nxserver_dir> <target_war> [command]\n    command may be empty or '%s' or '%s'", PackWar.class.getSimpleName(), COMMAND_PREPROCESSING, COMMAND_PACKAGING));
        }
        File nxserver = new File(args[0]).getAbsoluteFile();
        File war = new File(args[1]).getAbsoluteFile();
        String command = args.length == 3 ? args[2] : null;
        log.info((Object)("Packing nuxeo WAR at " + nxserver + " into " + war));
        try {
            new PackWar(nxserver, war).execute(command);
        }
        catch (Exception e) {
            PackWar.fail("Pack failed", e);
        }
    }

    protected static class WebXmlProcessor
    implements FileProcessor {
        public static WebXmlProcessor INSTANCE = new WebXmlProcessor();
        private static final String LISTENER = "listener";
        private static final String LISTENER_CLASS = "listener-class";

        protected WebXmlProcessor() {
        }

        @Override
        public void process(File file, OutputStream zout) throws IOException {
            DocumentBuilder parser;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            FileInputStream in = new FileInputStream(file);
            try {
                Document doc = parser.parse(in);
                doc.setStrictErrorChecking(false);
                for (Node c = doc.getDocumentElement().getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!LISTENER.equals(c.getNodeName())) continue;
                    Element listener = doc.createElement(LISTENER);
                    c.insertBefore(listener, c);
                    listener.appendChild(doc.createElement(LISTENER_CLASS)).appendChild(doc.createTextNode(NuxeoStarter.class.getName()));
                    break;
                }
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "no");
                trans.setOutputProperty("indent", "yes");
                trans.transform(new DOMSource(doc), new StreamResult(zout));
            }
            catch (SAXException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (TransformerException e) {
                throw (IOException)new IOException().initCause(e);
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    protected static class CopyProcessor
    implements FileProcessor {
        public static CopyProcessor INSTANCE = new CopyProcessor();

        protected CopyProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(File file, OutputStream out) throws IOException {
            FileInputStream in = new FileInputStream(file);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        }
    }

    protected static interface FileProcessor {
        public void process(File var1, OutputStream var2) throws IOException;
    }
}

