/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.client.vindoz.InstallAfterRestart;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="uninstallHandler")
public class UninstallHandler
extends DefaultObject {
    protected static final Log log = LogFactory.getLog(UninstallHandler.class);

    @GET
    @Produces(value={"text/html"})
    @Path(value="start/{pkgId}")
    public Object startUninstall(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source) {
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
            LocalPackage pkg = pus.getPackage(pkgId);
            Task uninstallTask = pkg.getUninstallTask();
            ValidationStatus status = uninstallTask.validate();
            if (status.hasErrors()) {
                return this.getView("canNotUninstall").arg("status", (Object)status).arg("pkg", (Object)pkg).arg("source", (Object)source);
            }
            PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
            List pkgToRemove = pm.getUninstallDependencies((Package)pkg);
            if (pkgToRemove.size() > 0) {
                return this.getView("displayDependencies").arg("pkg", (Object)pkg).arg("pkgToRemove", (Object)pkgToRemove).arg("source", (Object)source);
            }
            return this.getView("startUninstall").arg("status", (Object)status).arg("uninstallTask", (Object)uninstallTask).arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        catch (Exception e) {
            log.error((Object)"Error during first step of installation", (Throwable)e);
            return this.getView("uninstallError").arg("e", (Object)e);
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="run/{pkgId}")
    public Object doUninstall(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source) {
        PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        try {
            LocalPackage pkg = pus.getPackage(pkgId);
            PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
            List pkgToRemove = pm.getUninstallDependencies((Package)pkg);
            if (pkgToRemove.size() > 0) {
                for (DownloadablePackage rpkg : pkgToRemove) {
                    InstallAfterRestart.addPackageForUnInstallation(rpkg.getId());
                }
                InstallAfterRestart.addPackageForUnInstallation(pkgId);
                return this.getView("uninstallOnRestart").arg("pkg", (Object)pkg).arg("source", (Object)source);
            }
            if (InstallAfterRestart.isNeededForPackage((Package)pkg)) {
                InstallAfterRestart.addPackageForUnInstallation(pkgId);
                return this.getView("uninstallOnRestart").arg("pkg", (Object)pkg).arg("source", (Object)source);
            }
            Task uninstallTask = pkg.getUninstallTask();
            try {
                uninstallTask.run(new HashMap());
            }
            catch (Throwable e) {
                log.error((Object)("Error during uninstall of " + pkgId), e);
                uninstallTask.rollback();
                return this.getView("uninstallError").arg("e", (Object)e).arg("source", (Object)source);
            }
            return this.getView("uninstallDone").arg("uninstallTask", (Object)uninstallTask).arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        catch (Exception e) {
            log.error((Object)("Error during uninstall of " + pkgId), (Throwable)e);
            return this.getView("uninstallError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }

    @POST
    @Path(value="restart")
    public Object restartServer() {
        PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        try {
            pus.restart();
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        return Response.ok().build();
    }
}

