/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.ItemPermission;
import org.apache.directory.shared.ldap.aci.ProtectedItem;

public class ItemFirstACIItem
extends ACIItem {
    private static final long serialVersionUID = -8199453391060356463L;
    private final Collection protectedItems;
    private final Collection itemPermissions;

    public ItemFirstACIItem(String identificationTag, int precedence, AuthenticationLevel authenticationLevel, Collection protectedItems, Collection itemPermissions) {
        super(identificationTag, precedence, authenticationLevel);
        Iterator i = protectedItems.iterator();
        while (i.hasNext()) {
            if (ProtectedItem.class.isAssignableFrom(i.next().getClass())) continue;
            throw new IllegalArgumentException("protectedItems contains an element which is not a protected item.");
        }
        i = itemPermissions.iterator();
        while (i.hasNext()) {
            if (ItemPermission.class.isAssignableFrom(i.next().getClass())) continue;
            throw new IllegalArgumentException("itemPermissions contains an element which is not an item permission.");
        }
        this.protectedItems = Collections.unmodifiableCollection(new ArrayList(protectedItems));
        this.itemPermissions = Collections.unmodifiableCollection(new ArrayList(itemPermissions));
    }

    public Collection getProtectedItems() {
        return this.protectedItems;
    }

    public Collection getItemPermissions() {
        return this.itemPermissions;
    }

    public String toString() {
        return "itemFirstACIItem: identificationTag=" + this.getIdentificationTag() + ", " + "precedence=" + this.getPrecedence() + ", " + "authenticationLevel=" + this.getAuthenticationLevel() + ", " + "protectedItems=" + this.protectedItems + ", " + "itemPermissions=" + this.itemPermissions;
    }

    public Collection toTuples() {
        ArrayList<ACITuple> tuples = new ArrayList<ACITuple>();
        for (ItemPermission itemPermission : this.itemPermissions) {
            int precedence;
            Set grants = itemPermission.getGrants();
            Set denials = itemPermission.getDenials();
            int n = precedence = itemPermission.getPrecedence() >= 0 ? itemPermission.getPrecedence() : this.getPrecedence();
            if (grants.size() > 0) {
                tuples.add(new ACITuple(itemPermission.getUserClasses(), this.getAuthenticationLevel(), this.protectedItems, ItemFirstACIItem.toMicroOperations(grants), true, precedence));
            }
            if (denials.size() <= 0) continue;
            tuples.add(new ACITuple(itemPermission.getUserClasses(), this.getAuthenticationLevel(), this.protectedItems, ItemFirstACIItem.toMicroOperations(denials), false, precedence));
        }
        return tuples;
    }

    public void printToBuffer(StringBuffer buffer) {
        buffer.append('{');
        buffer.append(' ');
        buffer.append("identificationTag");
        buffer.append(' ');
        buffer.append('\"');
        buffer.append(this.getIdentificationTag());
        buffer.append('\"');
        buffer.append(',');
        buffer.append(' ');
        buffer.append("precedence");
        buffer.append(' ');
        buffer.append(this.getPrecedence());
        buffer.append(',');
        buffer.append(' ');
        buffer.append("authenticationLevel");
        buffer.append(' ');
        buffer.append(this.getAuthenticationLevel().getName());
        buffer.append(',');
        buffer.append(' ');
        buffer.append("itemOrUserFirst");
        buffer.append(' ');
        buffer.append("itemFirst");
        buffer.append(':');
        buffer.append(' ');
        buffer.append('{');
        buffer.append(' ');
        buffer.append("protectedItems");
        buffer.append(' ');
        buffer.append('{');
        buffer.append(' ');
        Iterator it = this.protectedItems.iterator();
        while (it.hasNext()) {
            ProtectedItem item = (ProtectedItem)it.next();
            item.printToBuffer(buffer);
            if (!it.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(' ');
        buffer.append('}');
        buffer.append(',');
        buffer.append(' ');
        buffer.append("itemPermissions");
        buffer.append(' ');
        buffer.append('{');
        buffer.append(' ');
        it = this.itemPermissions.iterator();
        while (it.hasNext()) {
            ItemPermission permission = (ItemPermission)it.next();
            permission.printToBuffer(buffer);
            if (!it.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(' ');
        buffer.append('}');
        buffer.append(' ');
        buffer.append('}');
        buffer.append(' ');
        buffer.append('}');
    }
}

