/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jbpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jbpm.AbstractWorkflowOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Workflow.UserJBPMTaskPageProvider", category="Services", label="UserTaskPageProvider", description="Returns the tasks waiting for the current user.")
public class UserTaskPageProviderOperation
extends AbstractWorkflowOperation {
    public static final String ID = "Workflow.UserJBPMTaskPageProvider";
    public static final String USER_TASKS_PAGE_PROVIDER = "user_tasks";
    @Param(name="language", required=false)
    protected String language;
    @Param(name="page", required=false)
    protected Integer page;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Context
    protected CoreSession session;
    @Context
    protected DocumentViewCodecManager documentViewCodecManager;

    @OperationMethod
    public Blob run() throws Exception {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        PageProvider pageProvider = pps.getPageProvider(USER_TASKS_PAGE_PROVIDER, null, targetPageSize, targetPage, props, new Object[0]);
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        JSONArray processes = new JSONArray();
        for (DashBoardItem dashBoardItem : pageProvider.getCurrentPage()) {
            boolean createdFromCreateTaskOperation = Boolean.parseBoolean((String)dashBoardItem.getTaskInstance().getVariableLocally("createdFromCreateTaskOperation"));
            JSONObject obj = new JSONObject();
            obj.put((Object)"taskName", (Object)(createdFromCreateTaskOperation ? dashBoardItem.getName() : this.getI18nTaskName(dashBoardItem.getName(), locale)));
            obj.put((Object)"directive", (Object)this.getI18nLabel(dashBoardItem.getDirective(), locale));
            obj.put((Object)"comment", (Object)dashBoardItem.getComment());
            Date dueDate = dashBoardItem.getDueDate();
            obj.put((Object)"dueDate", (Object)(dueDate != null ? DateParser.formatW3CDateTime((Date)dueDate) : ""));
            obj.put((Object)"documentTitle", (Object)dashBoardItem.getDocument().getTitle());
            obj.put((Object)"documentLink", (Object)this.getDocumentLink(this.documentViewCodecManager, dashBoardItem.getDocument(), !createdFromCreateTaskOperation));
            Date startDate = dashBoardItem.getStartDate();
            obj.put((Object)"startDate", (Object)(startDate != null ? DateParser.formatW3CDateTime((Date)startDate) : ""));
            processes.add((Object)obj);
        }
        JSONObject json = new JSONObject();
        json.put((Object)"isPaginable", (Object)Boolean.TRUE);
        json.put((Object)"totalSize", (Object)pageProvider.getResultsCount());
        json.put((Object)"pageIndex", (Object)pageProvider.getCurrentPageIndex());
        json.put((Object)"pageSize", (Object)pageProvider.getPageSize());
        json.put((Object)"pageCount", (Object)pageProvider.getNumberOfPages());
        json.put((Object)"entries", (Object)processes);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(json.toString().getBytes("UTF-8")), "application/json");
    }

    protected String getI18nTaskName(String taskName, Locale locale) {
        String labelKey = "label.workflow.task." + taskName;
        return this.getI18nLabel(labelKey, locale);
    }
}

