/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.ui;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.resources.ResourceManager;

public class Resources {
    private static final Log log = LogFactory.getLog(Resources.class);

    public static String render(Map<String, String> params, boolean virtualHosting) {
        String basepath;
        StringBuilder sb = new StringBuilder();
        String resourcePath = VirtualHostHelper.getContextPathProperty() + "/nxthemes-lib/";
        String themeUrl = params.get("themeUrl");
        String path = params.get("path");
        String nxthemeBasePath = basepath = params.get("basepath");
        ResourceManager resourceManager = Manager.getResourceManager();
        StringBuilder combinedStyles = new StringBuilder();
        StringBuilder combinedScripts = new StringBuilder();
        combinedStyles.append(resourcePath);
        combinedScripts.append(resourcePath);
        boolean hasScripts = false;
        boolean hasStyles = false;
        boolean ignoreLocal = false;
        if (params.containsKey("ignoreLocal")) {
            ignoreLocal = Boolean.parseBoolean(params.get("ignoreLocal"));
        }
        List resourceNames = ignoreLocal ? resourceManager.getGlobalResourcesFor(themeUrl) : resourceManager.getResourcesFor(themeUrl);
        for (String resourceName : resourceNames) {
            if (resourceName.endsWith(".css")) {
                combinedStyles.append(resourceName).append(",");
                hasStyles = true;
                continue;
            }
            if (!resourceName.endsWith(".js")) continue;
            combinedScripts.append(resourceName).append(",");
            hasScripts = true;
        }
        combinedStyles.deleteCharAt(combinedStyles.length() - 1);
        combinedScripts.deleteCharAt(combinedScripts.length() - 1);
        combinedStyles.append("?path=").append(path).append("&amp;basepath=").append(basepath);
        combinedScripts.append("?path=").append(path).append("&amp;basepath=").append(basepath);
        if (hasStyles) {
            sb.append(String.format("<link type=\"text/css\" rel=\"stylesheet\" media=\"all\" href=\"%s\"/>", combinedStyles.toString()));
        }
        String contextPath = params.get("contextPath");
        sb.append(String.format("<script type=\"text/javascript\"><!--\nvar nxthemesPath = \"%s\";\nvar nxthemesBasePath = \"%s\";\nvar nxContextPath = \"%s\";\n//--></script>\n", path, nxthemeBasePath, contextPath));
        if (hasScripts) {
            sb.append(String.format("<script type=\"text/javascript\" src=\"%s\"></script>", combinedScripts.toString()));
        }
        resourceManager.flush();
        return sb.toString();
    }
}

