/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.api.util;

import java.util.ArrayList;
import java.util.Properties;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.io.api.util.IOConfiguration;
import org.nuxeo.ecm.platform.io.api.util.IOHelper;
import org.nuxeo.ecm.platform.io.api.util.LocalConfiguration;
import org.nuxeo.ecm.platform.io.api.util.RemoteConfiguration;

public class Example {
    public static IOConfiguration createLocalConfiguration() {
        LocalConfiguration cfg = new LocalConfiguration();
        cfg.addDocument((DocumentRef)new PathRef("/default-domain/workspaces/ws1"));
        cfg.setProperty("org.nuxeo.ecm.core.io.doc_reader_factory", "org.nuxeo.MyReaderFactory");
        cfg.setProperty("put here factory properties if any too", "...");
        return cfg;
    }

    public static IOConfiguration createRemoteConfiguration() {
        Properties env = new Properties();
        env.put("java.naming.provider.url", "jnp://remote_host:1099");
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        RemoteConfiguration cfg = new RemoteConfiguration("nuxeo/IOManagerBean/remote", env);
        cfg.addDocument((DocumentRef)new PathRef("/default-domain/workspaces/ws1"));
        cfg.setProperty("org.nuxeo.ecm.core.io.doc_reader_factory", "org.nuxeo.MyReaderFactory");
        cfg.setProperty("put here factory properties if any too", "...");
        return cfg;
    }

    public static void copyFromLocalToRemote() throws Exception {
        IOConfiguration src = Example.createLocalConfiguration();
        IOConfiguration dest = Example.createRemoteConfiguration();
        ArrayList<String> ioAdapters = new ArrayList<String>();
        IOHelper.copy(src, dest, ioAdapters);
    }

    public static void copyFromLocalToLocal() throws Exception {
        IOConfiguration src = Example.createLocalConfiguration();
        IOConfiguration dest = Example.createLocalConfiguration();
        ArrayList<String> ioAdapters = new ArrayList<String>();
        IOHelper.copy(src, dest, ioAdapters);
    }

    public static void copyRemoteToRemote() throws Exception {
        IOConfiguration src = Example.createRemoteConfiguration();
        IOConfiguration dest = Example.createRemoteConfiguration();
        ArrayList<String> ioAdapters = new ArrayList<String>();
        IOHelper.copy(src, dest, ioAdapters);
    }

    public static void copyRemoteToLocal() throws Exception {
        IOConfiguration src = Example.createRemoteConfiguration();
        IOConfiguration dest = Example.createLocalConfiguration();
        ArrayList<String> ioAdapters = new ArrayList<String>();
        IOHelper.copy(src, dest, ioAdapters);
    }

    public static void main(String[] args) {
    }
}

