/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.localconfiguration.theme.negociation;

import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.localconfiguration.LocalThemeConfig;
import org.nuxeo.theme.localconfiguration.LocalThemeHelper;
import org.nuxeo.theme.negotiation.Negotiator;
import org.nuxeo.theme.negotiation.Scheme;
import org.nuxeo.theme.styling.service.ThemeStylingService;

public class LocalThemeFlavor
implements Scheme {
    private static final Log log = LogFactory.getLog(LocalThemeFlavor.class);

    public String getOutcome(Object context) {
        Boolean useOldThemeConf = Boolean.valueOf(Framework.getProperty((String)"theme.useOldLocalConfiguration"));
        if (Boolean.TRUE.equals(useOldThemeConf)) {
            return null;
        }
        DocumentModel currentSuperSpace = (DocumentModel)Component.getInstance((String)"currentSuperSpace");
        if (currentSuperSpace == null) {
            return null;
        }
        LocalThemeConfig localThemeConfig = LocalThemeHelper.getLocalThemeConfig((DocumentModel)currentSuperSpace);
        if (localThemeConfig == null) {
            return null;
        }
        String flavor = localThemeConfig.getFlavor();
        if (flavor == null) {
            return null;
        }
        FacesContext faces = (FacesContext)context;
        String theme = (String)faces.getExternalContext().getRequestMap().get("org.nuxeo.theme.negotiation.result." + Negotiator.NEGOTIATION_OBJECT.theme.name());
        if (theme != null) {
            try {
                ThemeStylingService service = (ThemeStylingService)Framework.getService(ThemeStylingService.class);
                if (service == null) {
                    log.error((Object)"Could not find the ThemeStylingService");
                    return null;
                }
                List flavors = service.getFlavorNames(theme);
                if (flavors.contains(flavor)) {
                    return flavor;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Local configuration: current theme page '%s' does not accept the flavor '%s'", theme, flavor));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return null;
    }
}

