/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.listener;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class DeleteTaskForDeletedDocumentListener
implements EventListener {
    private TaskService taskService;

    public TaskService getTaskService() {
        if (this.taskService == null) {
            try {
                this.taskService = (TaskService)Framework.getService(TaskService.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException("JbpmService is not deployed", (Throwable)e);
            }
        }
        return this.taskService;
    }

    public void handleEvent(Event event) throws ClientException {
        if ("aboutToRemove".equals(event.getName())) {
            DocumentEventContext context = (DocumentEventContext)event.getContext();
            DocumentModel dm = context.getSourceDocument();
            CoreSession coreSession = context.getCoreSession();
            NuxeoPrincipal principal = (NuxeoPrincipal)context.getPrincipal();
            List tasks = this.getTaskService().getTaskInstances(dm, (NuxeoPrincipal)null, coreSession);
            if (!tasks.isEmpty()) {
                for (Task task : tasks) {
                    this.getTaskService().deleteTaskInstance(coreSession, task.getId());
                }
            }
        }
    }
}

