/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.AbstractExecutor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;
import org.nuxeo.log4j.ThreadedStreamGobbler;

public class ShellExecutor
extends AbstractExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(ShellExecutor.class);

    @Override
    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params) {
        Process p1;
        Object[] cmd;
        long t0 = System.currentTimeMillis();
        ArrayList<String> output = new ArrayList<String>();
        if (ShellExecutor.isWindows()) {
            Object[] paramsArray = ShellExecutor.getParametersArray(cmdDesc, params);
            cmd = new String[]{"cmd", "/C", cmdDesc.getCommand()};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])paramsArray);
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])new String[]{"2>&1"});
        } else {
            String paramsString = ShellExecutor.getParametersString(cmdDesc, params) + " 2>&1";
            cmd = new String[]{"/bin/sh", "-c", cmdDesc.getCommand() + " " + paramsString};
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running system command: " + StringUtils.join((Object[])cmd, (String)" ")));
            }
            p1 = Runtime.getRuntime().exec((String[])cmd);
        }
        catch (IOException e) {
            return new ExecResult(e);
        }
        ThreadedStreamGobbler out = new ThreadedStreamGobbler(p1.getInputStream(), cmdDesc.getReadOutput() ? output : null);
        ThreadedStreamGobbler err = new ThreadedStreamGobbler(p1.getErrorStream(), 5);
        err.start();
        out.start();
        int exitCode = 0;
        try {
            exitCode = p1.waitFor();
            out.join();
            err.join();
        }
        catch (InterruptedException e) {
            return new ExecResult(e);
        }
        long t1 = System.currentTimeMillis();
        return new ExecResult(output, t1 - t0, exitCode);
    }
}

