/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.osgi.NullActivator;
import org.osgi.framework.BundleException;

public final class BundleManifestReader {
    private static final Log log = LogFactory.getLog(BundleManifestReader.class);
    private static final Pattern PARAMS_PATTERN = Pattern.compile("\\s*([^:\\s]+)\\s*:=\\s*([^;\\s]+)\\s*;?");
    public static String[] CUSTOM_HEADERS = new String[]{"Nuxeo-Component", "Nuxeo-WebModule"};

    private BundleManifestReader() {
    }

    public static Dictionary<String, String> getHeadersFromJar(URL url) {
        Manifest mf = JarUtils.getManifest((URL)url);
        if (mf != null) {
            try {
                return BundleManifestReader.getHeaders(mf);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return BundleManifestReader.getDefaultHeaders(url.toExternalForm());
    }

    public static Dictionary<String, String> getHeadersFromFile(File file) {
        Manifest mf = JarUtils.getManifest((File)file);
        if (mf != null) {
            try {
                return BundleManifestReader.getHeaders(mf);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return BundleManifestReader.getDefaultHeaders(file.getAbsolutePath());
    }

    public static Dictionary<String, String> getDefaultHeaders(String symbolicName) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put("Bundle-SymbolicName", symbolicName);
        ((Dictionary)headers).put("Bundle-Activator", NullActivator.class.getName());
        return headers;
    }

    public static Dictionary<String, String> getHeaders(Manifest mf) throws BundleException {
        Attributes attrs = mf.getMainAttributes();
        String symbolicName = attrs.getValue("Bundle-SymbolicName");
        if (symbolicName == null) {
            throw new BundleException("Missing attribute in Manifest (possibly cause by a missing new line at the end of the file): Bundle-SymbolicName");
        }
        Hashtable<String, String> headers = new Hashtable<String, String>();
        BundleManifestReader.parseSymbolicName(headers, symbolicName);
        String val = attrs.getValue("Bundle-Activator");
        if (val != null) {
            headers.put("Bundle-Activator", val.trim());
        }
        if ((val = attrs.getValue("Bundle-ClassPath")) != null) {
            headers.put("Bundle-ClassPath", val.trim());
        }
        if ((val = attrs.getValue("Bundle-Name")) != null) {
            headers.put("Bundle-Name", val);
        }
        if ((val = attrs.getValue("Bundle-Vendor")) != null) {
            headers.put("Bundle-Vendor", val);
        }
        if ((val = attrs.getValue("Bundle-Version")) != null) {
            headers.put("Bundle-Version", val);
        }
        if ((val = attrs.getValue("Bundle-Description")) != null) {
            headers.put("Bundle-Description", val);
        }
        if ((val = attrs.getValue("Bundle-DocURL")) != null) {
            headers.put("Bundle-DocURL", val);
        }
        if ((val = attrs.getValue("Bundle-Copyright")) != null) {
            headers.put("Bundle-Copyright", val);
        }
        if ((val = attrs.getValue("Bundle-Localization")) != null) {
            headers.put("Bundle-Localization", val);
        }
        if ((val = attrs.getValue("Require-Bundle")) != null) {
            headers.put("Require-Bundle", val);
        }
        for (String key : CUSTOM_HEADERS) {
            val = attrs.getValue(key);
            if (val == null) continue;
            headers.put(key, val);
        }
        return headers;
    }

    private static void parseSymbolicName(Dictionary<String, String> headers, String name) {
        int p = name.indexOf(59);
        if (p > 0) {
            headers.put("Bundle-SymbolicName", name.substring(0, p).trim());
            String tail = name.substring(p + 1);
            Matcher m = PARAMS_PATTERN.matcher(tail);
            while (m.find()) {
                headers.put(m.group(1), m.group(2));
            }
        } else {
            headers.put("Bundle-SymbolicName", name.trim());
        }
    }

    public static String removePropertiesFromHeaderValue(String value) {
        int p = value.indexOf(59);
        if (p > 0) {
            return value.substring(0, p).trim();
        }
        return value;
    }

    static {
        String h = System.getProperty("org.nuxeo.manifest.headers");
        if (h != null) {
            CUSTOM_HEADERS = StringUtils.split((String)h, (char)',', (boolean)true);
        }
    }
}

