/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.dnd;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.schema.utils.DateParser;

@Name(value="dndFormActions")
@Scope(value=ScopeType.PAGE)
public class DndFormActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Map<String, Serializable>> metadataCollector;
    protected String currentSchema;
    protected String currentLayout;
    @RequestParameter
    protected String schema;
    @RequestParameter
    protected String layout;

    public String getSchema() {
        if (this.schema != null && !this.schema.isEmpty()) {
            this.currentSchema = this.schema;
        }
        return this.currentSchema;
    }

    public String getLayout() {
        if (this.layout != null && !this.layout.isEmpty()) {
            this.currentLayout = this.layout;
        }
        return this.currentLayout;
    }

    @Factory(value="dataCollector", scope=ScopeType.PAGE)
    public Map<String, Map<String, Serializable>> getCollector() {
        if (this.metadataCollector == null) {
            this.metadataCollector = new HashMap<String, Map<String, Serializable>>();
            this.metadataCollector.put(this.getSchema(), new HashMap());
        }
        return this.metadataCollector;
    }

    public String save() throws JSONException {
        System.out.println("Saving DataCollector");
        for (String key : this.metadataCollector.keySet()) {
            System.out.println(key + " => " + this.metadataCollector.get(key).toString());
        }
        this.sendHtmlJSONResponse();
        return null;
    }

    public void sendHtmlJSONResponse() throws JSONException {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        HttpServletResponse response = (HttpServletResponse)econtext.getResponse();
        response.setContentType("text/html");
        try {
            response.getWriter().write(this.getCollectedData());
            response.flushBuffer();
        }
        catch (IOException e) {
            // empty catch block
        }
        context.responseComplete();
    }

    public String getCollectedData() throws JSONException {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n");
        sb.append("<script>\n");
        sb.append("var collectedData= ");
        JSONObject jsonObject = new JSONObject();
        JSONObject formData = new JSONObject();
        for (String key : this.metadataCollector.keySet()) {
            for (String field : this.metadataCollector.get(key).keySet()) {
                Object data = this.metadataCollector.get(key).get(field);
                if (data instanceof Date) {
                    data = DateParser.formatW3CDateTime((Date)((Date)data));
                } else if (data instanceof Calendar) {
                    data = DateParser.formatW3CDateTime((Date)((Calendar)data).getTime());
                }
                formData.put(key + ":" + field, data);
            }
        }
        jsonObject.put("docMetaData", (Object)formData);
        sb.append(jsonObject.toString());
        sb.append(";\n");
        sb.append("//console.log(collectedData);\n");
        sb.append("window.parent.dndFormFunctionCB(collectedData);\n");
        sb.append("</script>\n");
        sb.append("</html>");
        return sb.toString();
    }
}

