/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.querymodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.platform.ui.web.api.SortNotSupportedException;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="queryModelActions")
@Deprecated
public class QueryModelActionsBean
implements QueryModelActions,
Serializable {
    private static final long serialVersionUID = 7861380986688336804L;
    private static final Log log = LogFactory.getLog(QueryModelActionsBean.class);
    @In(create=true, required=false)
    transient CoreSession documentManager;
    @In(create=true, required=false)
    transient ResultsProvidersCache resultsProvidersCache;
    protected Map<String, QueryModel> queryModels;
    protected transient QueryModelService queryModelService;

    @Override
    public boolean isInitialized() {
        return this.documentManager != null;
    }

    @Override
    public QueryModel get(String queryModelName) throws ClientException {
        QueryModel model;
        if (this.queryModels == null) {
            this.queryModels = new HashMap<String, QueryModel>();
        }
        if ((model = this.queryModels.get(queryModelName)) == null) {
            QueryModelDescriptor descriptor;
            if (this.documentManager == null) {
                throw new ClientException("Cannot create QueryModel for '" + queryModelName + "'. DocumentManager is null.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("(Re)building query model " + queryModelName));
            }
            if ((descriptor = this.getQueryModelDescriptor(queryModelName)) == null) {
                throw new ClientException("No such query model: " + queryModelName);
            }
            if (descriptor.isStateless()) {
                model = new QueryModel(descriptor);
            } else {
                assert (descriptor.isStateful()) : queryModelName + " is neither stateless nor stateful";
                String docTypeName = descriptor.getDocType();
                model = new QueryModel(descriptor, this.documentManager.createDocumentModel(docTypeName));
            }
            this.queryModels.put(queryModelName, model);
        }
        return model;
    }

    public PagedDocumentsProvider getResultsProvider(String queryModelName) throws ClientException, ResultsProviderFarmUserException {
        try {
            return this.getResultsProvider(queryModelName, null);
        }
        catch (SortNotSupportedException e) {
            throw new ClientException("unexpected exception", (Throwable)e);
        }
    }

    public PagedDocumentsProvider getResultsProvider(String queryModelName, SortInfo sortInfo) throws ClientException, ResultsProviderFarmUserException {
        QueryModel model = this.get(queryModelName);
        QueryModelDescriptor descriptor = model.getDescriptor();
        if (descriptor.isStateless()) {
            throw new ClientException("queryModelActions is a ResultsProviderFarm for stateful query models only");
        }
        if (!descriptor.isSortable() && sortInfo != null) {
            throw new SortNotSupportedException();
        }
        PagedDocumentsProvider provider = model.getResultsProvider(this.documentManager, null, sortInfo);
        provider.setName(queryModelName);
        return provider;
    }

    @Override
    @Observer(value={"queryModelChanged"})
    public void queryModelChanged(QueryModel qm) {
        this.resultsProvidersCache.invalidate(qm.getDescriptor().getName());
    }

    protected QueryModelDescriptor getQueryModelDescriptor(String descriptorName) {
        if (this.queryModelService == null) {
            this.queryModelService = (QueryModelService)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService");
        }
        return this.queryModelService.getQueryModelDescriptor(descriptorName);
    }

    @Override
    public void reset(String queryModelName) throws ClientException {
        if (this.isPersisted(queryModelName)) {
            this.queryModels.remove(queryModelName);
        }
        QueryModel qm = this.get(queryModelName);
        qm.reset();
        Events.instance().raiseEvent("queryModelChanged", new Object[]{qm});
    }

    public void destroy() {
        log.debug((Object)"Removing component");
    }

    @Override
    public boolean isPersisted(String queryModelName) throws ClientException {
        QueryModelDescriptor descriptor = this.getQueryModelDescriptor(queryModelName);
        if (!descriptor.isStateful()) {
            return false;
        }
        return this.get(queryModelName).isPersisted();
    }

    @Override
    public QueryModel load(String queryModelName, DocumentRef ref) throws ClientException {
        QueryModelDescriptor descriptor;
        if (this.queryModels == null) {
            this.queryModels = new HashMap<String, QueryModel>();
        }
        if ((descriptor = this.getQueryModelDescriptor(queryModelName)) == null) {
            throw new ClientException(String.format("QueryModel '%s' does not exist", queryModelName));
        }
        if (!descriptor.isStateful()) {
            throw new ClientException(String.format("QueryModel '%s' is not stateful", queryModelName));
        }
        if (!this.isInitialized()) {
            throw new ClientException("Need a Core Session");
        }
        QueryModel qm = new QueryModel(descriptor, this.documentManager.getDocument(ref));
        this.queryModels.put(queryModelName, qm);
        Events.instance().raiseEvent("queryModelChanged", new Object[]{qm});
        return qm;
    }

    @Override
    public QueryModel persist(String queryModelName, String parentPath, String name) throws ClientException {
        return this.persist(queryModelName, parentPath, name, true);
    }

    @Override
    public QueryModel persist(String queryModelName, String parentPath, String name, boolean saveSession) throws ClientException {
        if (this.isPersisted(queryModelName)) {
            throw new ClientException(String.format("QueryModel '%s' has already been persisted", queryModelName));
        }
        QueryModelDescriptor descriptor = this.getQueryModelDescriptor(queryModelName);
        if (descriptor == null) {
            throw new ClientException(String.format("QueryModel '%s' does not exist", queryModelName));
        }
        if (!descriptor.isStateful()) {
            throw new ClientException(String.format("QueryModel '%s' is not stateful", queryModelName));
        }
        if (!this.isInitialized()) {
            throw new ClientException("Need a Core Session");
        }
        QueryModel qm = this.get(queryModelName);
        DocumentModel docqm = qm.getDocumentModel();
        DocumentModel doc = this.documentManager.createDocumentModel(docqm.getType());
        doc.copyContent(docqm);
        doc.setPathInfo(parentPath, name);
        doc = this.documentManager.createDocument(doc);
        if (saveSession) {
            this.documentManager.save();
        }
        qm.setPersisted(true);
        return new QueryModel(descriptor, doc);
    }
}

