/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.function;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.milyn.assertion.AssertArgument;
import org.milyn.function.StringFunction;
import org.milyn.function.StringFunctionDefinitionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFunctionExecutor {
    private static ConcurrentMap<String, StringFunctionExecutor> cache = new ConcurrentHashMap<String, StringFunctionExecutor>();
    private List<StringFunction> functions;
    private final String functionDefinition;

    public static StringFunctionExecutor getInstance(String functionDefinition) {
        StringFunctionExecutor existing;
        StringFunctionExecutor executor = (StringFunctionExecutor)cache.get(functionDefinition);
        if (executor == null && (existing = cache.putIfAbsent(functionDefinition, executor = new StringFunctionExecutor(functionDefinition, StringFunctionDefinitionParser.parse(functionDefinition)))) != null) {
            executor = existing;
        }
        return executor;
    }

    private StringFunctionExecutor(String functionDefinition, List<StringFunction> functions) {
        this.functionDefinition = functionDefinition;
        this.functions = functions;
    }

    public String execute(String input) {
        AssertArgument.isNotNull(input, "input");
        for (StringFunction function : this.functions) {
            input = function.execute(input);
        }
        return input;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("functionDefinition", (Object)this.functionDefinition).toString();
    }
}

