/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Dg;
import jxl.biff.drawing.DgContainer;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.ShapeType;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;
import jxl.biff.drawing.Spgr;
import jxl.biff.drawing.SpgrContainer;
import jxl.write.biff.File;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class SheetDrawingWriter {
    private static Log logger = Logging.getLog(SheetDrawingWriter.class);
    private ArrayList drawings;
    private boolean drawingsModified;
    private Chart[] charts = new Chart[0];
    private WorkbookSettings workbookSettings;

    public SheetDrawingWriter(WorkbookSettings ws) {
    }

    public void setDrawings(ArrayList dr, boolean mod) {
        this.drawings = dr;
        this.drawingsModified = mod;
    }

    public void write(File outputFile) throws IOException {
        DrawingGroupObject d2;
        if (this.drawings.size() == 0 && this.charts.length == 0) {
            return;
        }
        boolean modified = this.drawingsModified;
        int numImages = this.drawings.size();
        Iterator i = this.drawings.iterator();
        while (i.hasNext() && !modified) {
            DrawingGroupObject d = (DrawingGroupObject)i.next();
            if (d.getOrigin() == Origin.READ) continue;
            modified = true;
        }
        if (numImages > 0 && !modified && !(d2 = (DrawingGroupObject)this.drawings.get(0)).isFirst()) {
            modified = true;
        }
        if (numImages == 0 && this.charts.length == 1 && this.charts[0].getMsoDrawingRecord() == null) {
            modified = false;
        }
        if (!modified) {
            this.writeUnmodified(outputFile);
            return;
        }
        Object[] spContainerData = new Object[numImages + this.charts.length];
        int length = 0;
        EscherContainer firstSpContainer = null;
        int i2 = 0;
        while (i2 < numImages) {
            DrawingGroupObject drawing = (DrawingGroupObject)this.drawings.get(i2);
            EscherContainer spc = drawing.getSpContainer();
            if (spc != null) {
                byte[] data = spc.getData();
                spContainerData[i2] = data;
                if (i2 == 0) {
                    firstSpContainer = spc;
                } else {
                    length += data.length;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.charts.length) {
            EscherContainer spContainer = this.charts[i2].getSpContainer();
            byte[] data = spContainer.getBytes();
            data = spContainer.setHeaderData(data);
            spContainerData[i2 + numImages] = data;
            if (i2 == 0 && numImages == 0) {
                firstSpContainer = spContainer;
            } else {
                length += data.length;
            }
            ++i2;
        }
        DgContainer dgContainer = new DgContainer();
        Dg dg = new Dg(numImages + this.charts.length);
        dgContainer.add(dg);
        SpgrContainer spgrContainer = new SpgrContainer();
        SpContainer spContainer = new SpContainer();
        Spgr spgr = new Spgr();
        spContainer.add(spgr);
        Sp sp = new Sp(ShapeType.MIN, 1024, 5);
        spContainer.add(sp);
        spgrContainer.add(spContainer);
        spgrContainer.add(firstSpContainer);
        dgContainer.add(spgrContainer);
        byte[] firstMsoData = dgContainer.getData();
        int len = IntegerHelper.getInt(firstMsoData[4], firstMsoData[5], firstMsoData[6], firstMsoData[7]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 4);
        len = IntegerHelper.getInt(firstMsoData[28], firstMsoData[29], firstMsoData[30], firstMsoData[31]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 28);
        if (numImages > 0 && ((DrawingGroupObject)this.drawings.get(0)).isFormObject()) {
            byte[] msodata2 = new byte[firstMsoData.length - 8];
            System.arraycopy(firstMsoData, 0, msodata2, 0, msodata2.length);
            firstMsoData = msodata2;
        }
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(firstMsoData);
        outputFile.write(msoDrawingRecord);
        if (numImages > 0) {
            DrawingGroupObject firstDrawing = (DrawingGroupObject)this.drawings.get(0);
            firstDrawing.writeAdditionalRecords(outputFile);
        } else {
            Chart chart = this.charts[0];
            ObjRecord objRecord = chart.getObjRecord();
            outputFile.write(objRecord);
            outputFile.write(chart);
        }
        int i3 = 1;
        while (i3 < spContainerData.length) {
            byte[] bytes = (byte[])spContainerData[i3];
            if (i3 < numImages && ((DrawingGroupObject)this.drawings.get(i3)).isFormObject()) {
                byte[] bytes2 = new byte[bytes.length - 8];
                System.arraycopy(bytes, 0, bytes2, 0, bytes2.length);
                bytes = bytes2;
            }
            msoDrawingRecord = new MsoDrawingRecord(bytes);
            outputFile.write(msoDrawingRecord);
            if (i3 < numImages) {
                DrawingGroupObject d = (DrawingGroupObject)this.drawings.get(i3);
                d.writeAdditionalRecords(outputFile);
            } else {
                Chart chart = this.charts[i3 - numImages];
                ObjRecord objRecord = chart.getObjRecord();
                outputFile.write(objRecord);
                outputFile.write(chart);
            }
            ++i3;
        }
        for (DrawingGroupObject dgo2 : this.drawings) {
            dgo2.writeTailRecords(outputFile);
        }
    }

    private void writeUnmodified(File outputFile) throws IOException {
        if (this.charts.length == 0 && this.drawings.size() == 0) {
            return;
        }
        if (this.charts.length == 0 && this.drawings.size() != 0) {
            for (DrawingGroupObject d : this.drawings) {
                outputFile.write(d.getMsoDrawingRecord());
                d.writeAdditionalRecords(outputFile);
            }
            for (DrawingGroupObject d : this.drawings) {
                d.writeTailRecords(outputFile);
            }
            return;
        }
        if (this.drawings.size() == 0 && this.charts.length != 0) {
            Chart curChart = null;
            int i = 0;
            while (i < this.charts.length) {
                curChart = this.charts[i];
                if (curChart.getMsoDrawingRecord() != null) {
                    outputFile.write(curChart.getMsoDrawingRecord());
                }
                if (curChart.getObjRecord() != null) {
                    outputFile.write(curChart.getObjRecord());
                }
                outputFile.write(curChart);
                ++i;
            }
            return;
        }
        int numDrawings = this.drawings.size();
        int length = 0;
        EscherContainer[] spContainers = new EscherContainer[numDrawings + this.charts.length];
        boolean[] isFormObject = new boolean[numDrawings + this.charts.length];
        int i = 0;
        while (i < numDrawings) {
            DrawingGroupObject d = (DrawingGroupObject)this.drawings.get(i);
            spContainers[i] = d.getSpContainer();
            if (i > 0) {
                length += spContainers[i].getLength();
            }
            if (d.isFormObject()) {
                isFormObject[i] = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.charts.length) {
            spContainers[i + numDrawings] = this.charts[i].getSpContainer();
            length += spContainers[i + numDrawings].getLength();
            ++i;
        }
        DgContainer dgContainer = new DgContainer();
        Dg dg = new Dg(numDrawings + this.charts.length);
        dgContainer.add(dg);
        SpgrContainer spgrContainer = new SpgrContainer();
        SpContainer spContainer = new SpContainer();
        Spgr spgr = new Spgr();
        spContainer.add(spgr);
        Sp sp = new Sp(ShapeType.MIN, 1024, 5);
        spContainer.add(sp);
        spgrContainer.add(spContainer);
        spgrContainer.add(spContainers[0]);
        dgContainer.add(spgrContainer);
        byte[] firstMsoData = dgContainer.getData();
        int len = IntegerHelper.getInt(firstMsoData[4], firstMsoData[5], firstMsoData[6], firstMsoData[7]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 4);
        len = IntegerHelper.getInt(firstMsoData[28], firstMsoData[29], firstMsoData[30], firstMsoData[31]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 28);
        if (isFormObject[0]) {
            byte[] cbytes = new byte[firstMsoData.length - 8];
            System.arraycopy(firstMsoData, 0, cbytes, 0, cbytes.length);
            firstMsoData = cbytes;
        }
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(firstMsoData);
        outputFile.write(msoDrawingRecord);
        DrawingGroupObject dgo = (DrawingGroupObject)this.drawings.get(0);
        dgo.writeAdditionalRecords(outputFile);
        int i2 = 1;
        while (i2 < spContainers.length) {
            byte[] bytes = spContainers[i2].getBytes();
            byte[] bytes2 = spContainers[i2].setHeaderData(bytes);
            if (isFormObject[i2]) {
                byte[] cbytes = new byte[bytes2.length - 8];
                System.arraycopy(bytes2, 0, cbytes, 0, cbytes.length);
                bytes2 = cbytes;
            }
            msoDrawingRecord = new MsoDrawingRecord(bytes2);
            outputFile.write(msoDrawingRecord);
            if (i2 < numDrawings) {
                dgo = (DrawingGroupObject)this.drawings.get(i2);
                dgo.writeAdditionalRecords(outputFile);
            } else {
                Chart chart = this.charts[i2 - numDrawings];
                ObjRecord objRecord = chart.getObjRecord();
                outputFile.write(objRecord);
                outputFile.write(chart);
            }
            ++i2;
        }
        for (DrawingGroupObject dgo2 : this.drawings) {
            dgo2.writeTailRecords(outputFile);
        }
    }

    public void setCharts(Chart[] ch) {
        this.charts = ch;
    }

    public Chart[] getCharts() {
        return this.charts;
    }
}

