/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.querymodel.descriptor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.runtime.api.Framework;

@XObject(value="field")
public class FieldDescriptor {
    final SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @XNode(value="@name")
    protected String name;
    @XNode(value="@schema")
    protected String schema;
    @XNode(value="@xpath")
    protected String xpath;
    private String fieldType;

    public FieldDescriptor() {
    }

    public FieldDescriptor(String schema, String name) {
        this.name = name;
        this.schema = schema;
    }

    public FieldDescriptor(String xpath) {
        this.xpath = xpath;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getXpath() {
        return this.xpath;
    }

    public String getPlainStringValue(DocumentModel model) {
        Object rawValue = this.getRawValue(model);
        if (rawValue == null) {
            return null;
        }
        String value = (String)rawValue;
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    public Integer getIntValue(DocumentModel model) {
        Object rawValue = this.getRawValue(model);
        if (rawValue == null || "".equals(rawValue)) {
            return null;
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        if (rawValue instanceof String) {
            return Integer.valueOf((String)rawValue);
        }
        return Integer.valueOf(rawValue.toString());
    }

    public String getFieldType(DocumentModel model) throws ClientException {
        try {
            SchemaManager typeManager = (SchemaManager)Framework.getService(SchemaManager.class);
            Field field = null;
            if (this.xpath != null) {
                if (model != null) {
                    field = model.getProperty(this.xpath).getField();
                }
            } else {
                Schema schemaObj = typeManager.getSchema(this.schema);
                if (schemaObj == null) {
                    throw new ClientException("failed to obtain schema: " + this.schema);
                }
                field = schemaObj.getField(this.name);
            }
            if (field == null) {
                throw new ClientException("failed to obtain field: " + this.schema + ":" + this.name);
            }
            return field.getType().getName();
        }
        catch (Exception e) {
            throw new ClientException("failed to get field type for " + (this.xpath != null ? this.xpath : this.schema + ":" + this.name), (Throwable)e);
        }
    }

    public Object getRawValue(DocumentModel model) {
        try {
            if (this.xpath != null) {
                return model.getPropertyValue(this.xpath);
            }
            return model.getProperty(this.schema, this.name);
        }
        catch (ClientException e) {
            return null;
        }
    }

    public String getStringValue(DocumentModel model) throws ClientException {
        String value;
        Object rawValue = this.getRawValue(model);
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)rawValue;
            value = "TIMESTAMP '" + this.sf.format(gc.getTime()) + "'";
        } else if (rawValue instanceof Date) {
            Date date = (Date)rawValue;
            value = "TIMESTAMP '" + this.sf.format(date) + "'";
        } else if (rawValue instanceof Integer || rawValue instanceof Long || rawValue instanceof Double) {
            value = rawValue.toString();
        } else if (rawValue instanceof Boolean) {
            value = (Boolean)rawValue != false ? "1" : "0";
        } else {
            String value2 = rawValue.toString().trim();
            if (value2.equals("")) {
                return null;
            }
            if (this.fieldType == null) {
                this.fieldType = this.getFieldType(model);
            }
            if ("long".equals(this.fieldType) || "integer".equals(this.fieldType) || "double".equals(this.fieldType)) {
                return value2;
            }
            return QueryModelDescriptor.prepareStringLiteral(value2);
        }
        return value;
    }

    public List<String> getListValue(DocumentModel model) {
        Object[] rawValue = this.getRawValue(model);
        if (rawValue == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        if (rawValue instanceof ArrayList) {
            rawValue = ((ArrayList)rawValue).toArray();
        }
        for (Object element : (Object[])rawValue) {
            String value;
            if (element == null || (value = element.toString().trim()).equals("")) continue;
            values.add("'" + value + "'");
        }
        return values;
    }

    public Boolean getBooleanValue(DocumentModel model) {
        Object rawValue = this.getRawValue(model);
        if (rawValue == null) {
            return null;
        }
        return (Boolean)rawValue;
    }
}

