/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.search.results.document;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultItem;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.DocumentModelResultItem;

@Deprecated
public class SearchPageProvider
implements PagedDocumentsProvider {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SearchPageProvider.class);
    private static final DocumentModelList EMPTY = new DocumentModelListImpl();
    private ResultSet searchResults;
    private final String query;
    private DocumentModelList currentPageDocList;
    private String providerName;
    private SortInfo sortInfo;
    private boolean sortable;
    private boolean pendingRefresh = false;
    private boolean pageChanged = false;

    public SearchPageProvider(ResultSet set, boolean sortable, SortInfo sortInfo, String query) {
        this.searchResults = set;
        this.sortInfo = sortInfo;
        this.sortable = sortable;
        this.query = query;
    }

    public SearchPageProvider(ResultSet set) {
        this(set, false, null, null);
    }

    public DocumentModelList getCurrentPage() {
        if (this.currentPageDocList != null) {
            return this.currentPageDocList;
        }
        try {
            if (this.pendingRefresh && !this.pageChanged) {
                this.performRefresh();
            }
            this.currentPageDocList = this.constructDocumentModels();
            return this.currentPageDocList;
        }
        catch (SearchException e) {
            log.error((Object)"Catched a SearchException", (Throwable)e);
            return EMPTY;
        }
    }

    public int getCurrentPageIndex() {
        int pag = this.searchResults.getPageNumber();
        return pag - 1;
    }

    public String getCurrentPageStatus() {
        int total = this.getNumberOfPages();
        int current = this.getCurrentPageIndex() + 1;
        if (total == -1) {
            return String.format("%d", current);
        }
        return String.format("%d/%d", current, total);
    }

    public DocumentModelList getNextPage() {
        this.next();
        return this.getCurrentPage();
    }

    public void goToPage(int page) {
        ++page;
        try {
            ResultSet res = this.searchResults.goToPage(page);
            if (res == null) {
                return;
            }
            this.searchResults = res;
            this.currentPageDocList = null;
            this.pageChanged = true;
        }
        catch (SearchException e) {
            log.error((Object)"getPage failed", (Throwable)e);
        }
    }

    public DocumentModelList getPage(int page) {
        this.goToPage(page);
        return this.getCurrentPage();
    }

    public long getResultsCount() {
        return this.searchResults.getTotalHits();
    }

    public boolean isNextPageAvailable() {
        return this.searchResults.hasNextPage();
    }

    public String getQuery() {
        return this.query;
    }

    public void last() {
        this.goToPage(this.getNumberOfPages() - 1);
    }

    public void next() {
        if (this.isNextPageAvailable()) {
            this.goToPage(this.getCurrentPageIndex() + 1);
        }
    }

    public void previous() {
        int i = this.getCurrentPageIndex();
        if (i > 0) {
            this.goToPage(i - 1);
        }
    }

    public void rewind() {
        this.goToPage(0);
    }

    public boolean isPreviousPageAvailable() {
        return this.getCurrentPageIndex() > 0;
    }

    public int getNumberOfPages() {
        int range = this.searchResults.getRange();
        if (range == 0) {
            return 1;
        }
        return (int)(1L + (this.getResultsCount() - 1L) / (long)range);
    }

    protected void performRefresh() throws SearchException {
        this.searchResults = this.searchResults.replay();
        this.pendingRefresh = false;
    }

    public void refresh() {
        this.pendingRefresh = true;
        this.currentPageDocList = null;
    }

    public int getCurrentPageOffset() {
        return this.searchResults.getOffset();
    }

    public int getCurrentPageSize() {
        return this.searchResults.getPageHits();
    }

    public int getPageSize() {
        return this.searchResults.getRange();
    }

    protected DocumentModelList constructDocumentModels() {
        if (this.searchResults == null) {
            return EMPTY;
        }
        int pageHits = this.searchResults.getPageHits();
        ArrayList<DocumentModel> res = new ArrayList<DocumentModel>(pageHits);
        for (int i = 0; i < pageHits; ++i) {
            ResultItem rItem = (ResultItem)this.searchResults.get(i);
            DocumentModel doc = ((DocumentModelResultItem)rItem).getDocumentModel();
            res.add(doc);
        }
        this.pageChanged = false;
        return new DocumentModelListImpl(res);
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public String getName() {
        return this.providerName;
    }

    public void setName(String name) {
        this.providerName = name;
    }
}

