/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.plateform.jbpm.core.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.plateform.jbpm.core.task.TaskMigrationRunner;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class JBPMDocTaskProvider
implements TaskProvider {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(JBPMDocTaskProvider.class);
    public static final String PUBLISHER_JBPMTASK_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    public static final String PUBLISHER_TASK_NAME = "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory";
    private JbpmService jbpmService;
    private TaskService taskService;
    private UserManager userManager;

    public static void eagerLoadTaskInstance(TaskInstance ti) {
        if (ti.getPooledActors() != null) {
            ti.getPooledActors().size();
        }
        if (ti.getVariableInstances() != null) {
            ti.getVariableInstances().size();
        }
        if (ti.getComments() != null) {
            ti.getComments().size();
        }
        if (ti.getToken() != null) {
            ti.getToken().getId();
        }
    }

    public List<Task> getCurrentTaskInstances(final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getCurrentTaskInstances((NuxeoPrincipal)coreSession.getPrincipal(), null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public List<Task> getCurrentTaskInstances(final List<String> actors, final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getCurrentTaskInstances(actors, null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public List<Task> getTaskInstances(final DocumentModel dm, final NuxeoPrincipal user, final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getTaskInstances(dm, user, null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public List<Task> getTaskInstances(final DocumentModel dm, final List<String> actors, final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getTaskInstances(dm, actors, null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public JbpmService getJbpmService() {
        if (this.jbpmService == null) {
            try {
                this.jbpmService = (JbpmService)Framework.getService(JbpmService.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Jbpm service is not deployed.", e);
            }
        }
        return this.jbpmService;
    }

    public TaskService getTaskService() {
        if (this.taskService == null) {
            try {
                this.taskService = (TaskService)Framework.getService(TaskService.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Task service is not deployed.", e);
            }
        }
        return this.taskService;
    }

    public UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("UserManager service is not deployed.", e);
            }
        }
        return this.userManager;
    }
}

