/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetConverterDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class WidgetConverterRegistry
extends ContributionFragmentRegistry<WidgetConverterDescriptor> {
    protected final String category;
    protected final Map<String, WidgetConverterDescriptor> converters;

    public WidgetConverterRegistry(String category) {
        this.category = category;
        this.converters = new HashMap<String, WidgetConverterDescriptor>();
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getLayoutNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.converters.keySet());
        return res;
    }

    public String getContributionId(WidgetConverterDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, WidgetConverterDescriptor contrib, WidgetConverterDescriptor newOrigContrib) {
        this.converters.put(id, contrib);
    }

    public void contributionRemoved(String id, WidgetConverterDescriptor origContrib) {
        this.converters.remove(id);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public WidgetConverterDescriptor clone(WidgetConverterDescriptor orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(WidgetConverterDescriptor src, WidgetConverterDescriptor dst) {
        throw new UnsupportedOperationException();
    }

    public List<WidgetConverterDescriptor> getConverters() {
        ArrayList<WidgetConverterDescriptor> res = new ArrayList<WidgetConverterDescriptor>();
        for (WidgetConverterDescriptor item : this.converters.values()) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    public WidgetConverterDescriptor getConverter(String id) {
        return this.converters.get(id);
    }
}

