/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.impl.PackagePersistence;
import org.nuxeo.connect.update.impl.task.commands.Append;
import org.nuxeo.connect.update.impl.task.commands.Command;
import org.nuxeo.connect.update.impl.task.commands.Config;
import org.nuxeo.connect.update.impl.task.commands.Copy;
import org.nuxeo.connect.update.impl.task.commands.Delete;
import org.nuxeo.connect.update.impl.task.commands.Deploy;
import org.nuxeo.connect.update.impl.task.commands.DeployConfig;
import org.nuxeo.connect.update.impl.task.commands.Flush;
import org.nuxeo.connect.update.impl.task.commands.FlushCoreCache;
import org.nuxeo.connect.update.impl.task.commands.FlushJaasCache;
import org.nuxeo.connect.update.impl.task.commands.Install;
import org.nuxeo.connect.update.impl.task.commands.LoadJar;
import org.nuxeo.connect.update.impl.task.commands.ParameterizedCopy;
import org.nuxeo.connect.update.impl.task.commands.ReloadProperties;
import org.nuxeo.connect.update.impl.task.commands.UnAppend;
import org.nuxeo.connect.update.impl.task.commands.Undeploy;
import org.nuxeo.connect.update.impl.task.commands.UndeployConfig;
import org.nuxeo.connect.update.impl.task.commands.Uninstall;
import org.nuxeo.connect.update.impl.task.commands.UnloadJar;
import org.nuxeo.connect.update.impl.xml.FormsDefinition;
import org.nuxeo.connect.update.impl.xml.PackageDefinitionImpl;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.runtime.reload.NuxeoRestart;

public class UpdateServiceImpl
implements PackageUpdateService {
    protected static XMap xmap;
    protected PackagePersistence persistence = new PackagePersistence();
    protected Map<String, Class<? extends Command>> commands = new HashMap<String, Class<? extends Command>>();

    public static XMap getXmap() {
        return xmap;
    }

    public PackagePersistence getPersistence() {
        return this.persistence;
    }

    public LocalPackage addPackage(File file) throws PackageException {
        return this.persistence.addPackage(file);
    }

    public void removePackage(String id) throws PackageException {
        this.persistence.removePackage(id);
    }

    public LocalPackage getPackage(String id) throws PackageException {
        return this.persistence.getPackage(id);
    }

    public List<LocalPackage> getPackages() throws PackageException {
        return this.persistence.getPackages();
    }

    public static XMap createXmap() {
        XMap xmap = new XMap();
        xmap.setValueFactory(PackageType.class, new XValueFactory(){

            public String serialize(Context arg0, Object arg1) {
                return ((PackageType)arg1).getValue();
            }

            public Object deserialize(Context arg0, String arg1) {
                return PackageType.getByValue((String)arg1);
            }
        });
        xmap.setValueFactory(Version.class, new XValueFactory(){

            public String serialize(Context arg0, Object arg1) {
                return arg1.toString();
            }

            public Object deserialize(Context arg0, String arg1) {
                return new Version(arg1);
            }
        });
        xmap.setValueFactory(PackageDependency.class, new XValueFactory(){

            public String serialize(Context arg0, Object arg1) {
                return arg1.toString();
            }

            public Object deserialize(Context arg0, String arg1) {
                return new PackageDependency(arg1);
            }
        });
        xmap.register(PackageDefinitionImpl.class);
        xmap.register(FormsDefinition.class);
        return xmap;
    }

    public void initialize() throws PackageException {
        xmap = UpdateServiceImpl.createXmap();
        this.addCommand("copy", Copy.class);
        this.addCommand("append", Append.class);
        this.addCommand("unappend", UnAppend.class);
        this.addCommand("pcopy", ParameterizedCopy.class);
        this.addCommand("delete", Delete.class);
        this.addCommand("install", Install.class);
        this.addCommand("uninstall", Uninstall.class);
        this.addCommand("flush-core", FlushCoreCache.class);
        this.addCommand("flush-jaas", FlushJaasCache.class);
        this.addCommand("flush", Flush.class);
        this.addCommand("reload-properties", ReloadProperties.class);
        this.addCommand("deploy", Deploy.class);
        this.addCommand("undeploy", Undeploy.class);
        this.addCommand("deploy-config", DeployConfig.class);
        this.addCommand("undeploy-config", UndeployConfig.class);
        this.addCommand("load-jar", LoadJar.class);
        this.addCommand("unload-jar", UnloadJar.class);
        this.addCommand("config", Config.class);
        this.startInstalledPackages();
    }

    public void setPackageState(LocalPackage pkg, int state) throws PackageException {
        this.persistence.updateState(pkg.getId(), state);
        pkg.setState(state);
    }

    public void shutdown() throws PackageException {
        xmap = null;
    }

    public Command getCommand(String id) throws PackageException {
        Class<? extends Command> type = this.commands.get(id);
        if (type != null) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PackageException("Failed to load command " + id, (Throwable)e);
            }
        }
        return null;
    }

    public void addCommand(String id, Class<? extends Command> cmd) {
        this.commands.put(id, cmd);
    }

    public void removeCommand(String id) {
        this.commands.remove(id);
    }

    public LocalPackage getActivePackage(String name) throws PackageException {
        return this.persistence.getActivePackage(name);
    }

    public void restart() throws PackageException {
        try {
            NuxeoRestart.restart();
        }
        catch (Throwable t) {
            throw new PackageException("Failed to restart Nuxeo", t);
        }
    }

    public PackageDefinition loadPackageFromZip(File file) throws PackageException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            ZipEntry mfEntry = zip.getEntry("package.xml");
            InputStream mfStream = zip.getInputStream(mfEntry);
            PackageDefinition packageDefinition = this.loadPackage(mfStream);
            return packageDefinition;
        }
        catch (PackageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PackageException("Failed to load package definition from zip file: " + file, (Throwable)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    throw new PackageException("Failed to close package zip: " + file, (Throwable)e);
                }
            }
        }
    }

    public PackageDefinition loadPackage(File file) throws PackageException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            PackageDefinition packageDefinition = this.loadPackage(in);
            return packageDefinition;
        }
        catch (PackageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PackageException("Failed to load XML package definition from file: " + file, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new PackageException("Failed to close input stream for " + file, (Throwable)e);
            }
        }
    }

    public PackageDefinition loadPackage(InputStream in) throws PackageException {
        try {
            return (PackageDefinition)xmap.load(in);
        }
        catch (Exception e) {
            throw new PackageException("Failed to parse XML package definition", (Throwable)e);
        }
    }

    protected void startInstalledPackages() throws PackageException {
        for (Map.Entry<String, Integer> entry : this.persistence.getStates().entrySet()) {
            if (entry.getValue() != 4) continue;
            this.persistence.updateState(entry.getKey(), 5);
        }
    }

    public void reset() throws PackageException {
        this.persistence.reset();
    }
}

