/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.File;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateComponent;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.commands.AbstractCommand;
import org.nuxeo.connect.update.impl.task.commands.Command;
import org.nuxeo.connect.update.impl.task.commands.Install;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Element;

public class Uninstall
extends AbstractCommand {
    public static final String ID = "uninstall";
    protected File file;

    public Uninstall() {
        super(ID);
    }

    public Uninstall(File file) {
        super(ID);
        this.file = file;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.file == null) {
            status.addError("Invalid uninstall syntax: No file specified");
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        block14: {
            BundleContext ctx = PackageUpdateComponent.getContext().getBundle().getBundleContext();
            JarFile jar = null;
            try {
                jar = new JarFile(this.file);
                Manifest mf = jar.getManifest();
                String name = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                if (name == null) break block14;
                for (Bundle bundle : ctx.getBundles()) {
                    if (!name.equals(bundle.getSymbolicName())) continue;
                    try {
                        if (bundle.getState() == 32) {
                            bundle.uninstall();
                        }
                    }
                    catch (Throwable t) {
                        task.setRestartRequired(true);
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new PackageException("Failed to uninstall bundle: " + this.file.getName(), (Throwable)e);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return new Install(this.file);
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() > 0) {
            this.file = new File(v);
            this.guardVars.put("file", this.file);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        writer.end();
    }
}

