/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPOptions;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.JenaHandler;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.impl.RDFXMLParser;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.UnknownPropertyException;
import com.hp.hpl.jena.shared.WrappedIOException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JenaReader
implements RDFReader,
ARPErrorNumbers {
    private static final String saxFeaturesURL = "http://xml.org/sax/features/";
    private static final String saxPropertiesURL = "http://xml.org/sax/properties/";
    private static final String apacheFeaturesURL = "http://apache.org/xml/features/";
    private static final String apachePropertiesURL = "http://apache.org/xml/properties/";
    static final String arpPropertiesURL = "http://jena.hpl.hp.com/arp/properties/";
    static final int arpPropertiesURLLength = "http://jena.hpl.hp.com/arp/properties/".length();
    private final RDFXMLParser arpf;
    private Model model;
    private JenaHandler handler;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public JenaReader() {
        this.arpf = RDFXMLParser.create();
    }

    public void read(Model m, String url) throws JenaException {
        try {
            URLConnection conn = new URL(url).openConnection();
            conn.setRequestProperty("accept", "application/rdf+xml, application/xml; q=0.8, text/xml; q=0.7, application/rss+xml; q=0.3, */*; q=0.2");
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                this.read(m, conn.getInputStream(), url);
            } else {
                this.read(m, (Reader)new InputStreamReader(conn.getInputStream(), encoding), url);
            }
        }
        catch (FileNotFoundException e) {
            throw new DoesNotExistException(url);
        }
        catch (IOException e) {
            throw new JenaException(e);
        }
    }

    private static Node convert(ALiteral lit) {
        String dtURI = lit.getDatatypeURI();
        if (dtURI == null) {
            return Node.createLiteral(((Object)lit).toString(), lit.getLang(), false);
        }
        if (lit.isWellFormedXML()) {
            return Node.createLiteral(((Object)lit).toString(), null, true);
        }
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
        return Node.createLiteral(((Object)lit).toString(), null, dt);
    }

    private static Node convert(AResource r) {
        if (!r.isAnonymous()) {
            return Node.createURI(r.getURI());
        }
        Node rr = (Node)r.getUserData();
        if (rr == null) {
            rr = Node.createAnon();
            r.setUserData(rr);
        }
        return rr;
    }

    static Triple convert(AResource s, AResource p, AResource o) {
        return Triple.create(JenaReader.convert(s), JenaReader.convert(p), JenaReader.convert(o));
    }

    static Triple convert(AResource s, AResource p, ALiteral o) {
        return Triple.create(JenaReader.convert(s), JenaReader.convert(p), JenaReader.convert(o));
    }

    private void read(Model m, InputSource inputS, String xmlBase) throws JenaException {
        this.model = m;
        this.read(this.model.getGraph(), inputS, xmlBase, this.model);
    }

    private synchronized void read(Graph g, InputSource inputS, String xmlBase, Model m) {
        try {
            g.getEventManager().notifyEvent(g, GraphEvents.startRead);
            inputS.setSystemId(xmlBase);
            this.handler = new JenaHandler(g, m, this.errorHandler);
            this.handler.useWith(this.arpf.getHandlers());
            this.arpf.parse(inputS, xmlBase);
            this.handler.bulkUpdate();
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        catch (SAXException e) {
            throw new JenaException(e);
        }
        finally {
            g.getEventManager().notifyEvent(g, GraphEvents.finishRead);
            this.handler = null;
        }
    }

    public void read(Model m, Reader reader, String xmlBase) throws JenaException {
        this.read(m, new InputSource(reader), xmlBase);
    }

    public void read(Graph g, Reader reader, String xmlBase) throws JenaException {
        this.read(g, new InputSource(reader), xmlBase, null);
    }

    public void read(Model m, InputStream in, String xmlBase) throws JenaException {
        this.read(m, new InputSource(in), xmlBase);
    }

    public void read(Graph g, InputStream in, String xmlBase) {
        this.read(g, new InputSource(in), xmlBase, null);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        JenaHandler h = this.handler;
        if (h != null) {
            h.setErrorHandler(errHandler);
        }
        return old;
    }

    public Object setProperty(String str, Object value) throws JenaException {
        Object obj = value;
        if (str.startsWith("http:")) {
            if (str.startsWith(arpPropertiesURL)) {
                return this.setArpProperty(str.substring(arpPropertiesURLLength), obj);
            }
            if (str.startsWith(saxPropertiesURL) || str.startsWith(apachePropertiesURL)) {
                Object old;
                try {
                    old = this.arpf.getSAXParser().getProperty(str);
                }
                catch (SAXNotSupportedException ns) {
                    old = null;
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setProperty(str, obj);
                }
                catch (SAXNotSupportedException ns) {
                    this.errorHandler.error(new JenaException(ns));
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                return old;
            }
            if (str.startsWith(saxFeaturesURL) || str.startsWith(apacheFeaturesURL)) {
                Boolean old;
                try {
                    old = new Boolean(this.arpf.getSAXParser().getFeature(str));
                }
                catch (SAXNotSupportedException ns) {
                    old = null;
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setFeature(str, ((Boolean)obj).booleanValue());
                }
                catch (SAXNotSupportedException ns) {
                    this.errorHandler.error(new JenaException(ns));
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                catch (ClassCastException cc) {
                    this.errorHandler.error(new JenaException(new SAXNotSupportedException("Feature: '" + str + "' can only have a boolean value.")));
                }
                return old;
            }
        }
        return this.setArpProperty(str, obj);
    }

    private Object setArpProperty(String str, Object v) {
        return JenaReader.processArpOptions(this.getOptions(), str, v, this.errorHandler);
    }

    public ARPOptions getOptions() {
        return this.arpf.getOptions();
    }

    public void setOptionsWith(ARPOptions opts) {
        this.arpf.setOptionsWith(opts);
    }

    static Object processArpOptions(ARPOptions options, String str, Object v, RDFErrorHandler eh) {
        int cond;
        str = str.toUpperCase();
        if (v == null) {
            v = "";
        }
        if (v instanceof String) {
            v = ((String)v).toUpperCase();
        }
        if (str.equals("ERROR-MODE")) {
            if (v instanceof String) {
                String val = (String)v;
                if (val.equals("LAX")) {
                    options.setLaxErrorMode();
                    return null;
                }
                if (val.equals("DEFAULT")) {
                    options.setDefaultErrorMode();
                    return null;
                }
                if (val.equals("STRICT")) {
                    options.setStrictErrorMode();
                    return null;
                }
                if (val.equals("STRICT-WARNING")) {
                    options.setStrictErrorMode(1);
                    return null;
                }
                if (val.equals("STRICT-FATAL")) {
                    options.setStrictErrorMode(3);
                    return null;
                }
                if (val.equals("STRICT-IGNORE")) {
                    options.setStrictErrorMode(0);
                    return null;
                }
                if (val.equals("STRICT-ERROR")) {
                    options.setStrictErrorMode(2);
                    return null;
                }
            }
            eh.error(new IllegalArgumentException("Property \"ERROR-MODE\" takes the following values: \"default\", \"lax\", \"strict\", \"strict-ignore\", \"strict-warning\", \"strict-error\", \"strict.error\"."));
            return null;
        }
        if (str.equals("EMBEDDING")) {
            if (v instanceof String) {
                v = Boolean.valueOf((String)v);
            }
            if (v instanceof Boolean) {
                return new Boolean(options.setEmbedding((Boolean)v));
            }
            eh.error(new IllegalArgumentException("Property \"EMBEDDING\" requires a boolean value."));
            boolean old = options.setEmbedding(false);
            options.setEmbedding(old);
            return new Boolean(old);
        }
        if ((str.startsWith("ERR_") || str.startsWith("IGN_") || str.startsWith("WARN_")) && (cond = ParseException.errorCode(str)) != -1) {
            int val;
            if (v instanceof String) {
                if (((String)v).startsWith("EM_") && (val = ParseException.errorCode((String)v)) != -1) {
                    int rslt = options.setErrorMode(cond, val);
                    return new Integer(rslt);
                }
            } else if (v instanceof Integer) {
                val = (Integer)v;
                switch (val) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int rslt = options.setErrorMode(cond, val);
                        return new Integer(rslt);
                    }
                }
            }
            eh.error(new IllegalArgumentException("Property \"" + str + "\" cannot have value: " + v.toString()));
            int old = options.setErrorMode(cond, 2);
            options.setErrorMode(cond, old);
            return new Integer(old);
        }
        if (str.equals("IRI-RULES")) {
            IRIFactory old = options.getIRIFactory();
            if (v.equals("STRICT")) {
                options.setIRIFactory(IRIFactory.semanticWebImplementation());
            } else if (v.equals("IRI")) {
                options.setIRIFactory(IRIFactory.iriImplementation());
            } else if (v.equals("LAX")) {
                options.setIRIFactory(IRIFactory.jenaImplementation());
            } else {
                eh.error(new IllegalArgumentException("Property \"IRI-RULES\" requires one of 'STRICT', 'IRI' or 'LAX'"));
            }
            return old;
        }
        eh.error(new UnknownPropertyException(str));
        return null;
    }
}

