/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;

public class SingleShadowDocumentWriter
extends AbstractDocumentModelWriter {
    private static final Log log = LogFactory.getLog(SingleShadowDocumentWriter.class);
    protected DocumentModel dm;

    public SingleShadowDocumentWriter(CoreSession session, String parentPath) {
        super(session, "/");
    }

    public DocumentTranslationMap write(ExportedDocument doc) throws IOException {
        try {
            this.dm = this.createDocument(doc, null);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        DocumentLocation oldLoc = doc.getSourceLocation();
        String oldServerName = oldLoc.getServerName();
        DocumentRef oldDocRef = oldLoc.getDocRef();
        DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(oldServerName, oldServerName);
        map.put(oldDocRef, oldDocRef);
        return map;
    }

    protected DocumentModel createDocument(ExportedDocument xdoc, Path toPath) throws ClientException {
        String docType = xdoc.getType();
        this.dm = this.session.createDocumentModel(docType);
        this.loadSchemas(xdoc, this.dm, xdoc.getDocument());
        return this.dm;
    }

    public DocumentModel getShadowDocument() {
        return this.dm;
    }
}

