/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.server;

import java.io.Serializable;
import java.util.Map;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.publisher.api.AbstractBasePublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.remoting.server.ExternalCorePublishedDocument;
import org.nuxeo.runtime.api.Framework;

public class SimpleExternalDocumentModelFactory
extends AbstractBasePublishedDocumentFactory
implements PublishedDocumentFactory {
    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        PathSegmentService pss;
        try {
            pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        doc.setPathInfo(targetNode.getPath(), "remote_doc_" + pss.generatePathSegment(doc));
        ScopedMap ctxData = doc.getContextData();
        ctxData.putScopedValue(ScopeType.REQUEST, "SKIP_VERSIONING", (Serializable)Boolean.valueOf(true));
        doc = this.coreSession.createDocument(doc);
        this.coreSession.save();
        return new ExternalCorePublishedDocument(doc);
    }

    protected boolean needToVersionDocument(DocumentModel doc) {
        if (!doc.getRepositoryName().equalsIgnoreCase(this.coreSession.getRepositoryName())) {
            return false;
        }
        return super.needToVersionDocument(doc);
    }

    public PublishedDocument wrapDocumentModel(DocumentModel doc) throws ClientException {
        if (doc.isProxy()) {
            return new SimpleCorePublishedDocument(doc);
        }
        return new ExternalCorePublishedDocument(doc);
    }
}

