/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public class PictureBookBlobHolder
extends DocumentBlobHolder {
    private CoreSession session;

    public PictureBookBlobHolder(DocumentModel doc, String xPath) {
        super(doc, xPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob() throws ClientException {
        CoreSession session = this.getSession();
        boolean sessionOpened = false;
        if (session == null) {
            sessionOpened = true;
            session = this.openNewSession();
        }
        try {
            DocumentModel documentModel = (DocumentModel)session.getChildrenIterator(this.doc.getRef(), "Picture").next();
            PictureResourceAdapter picture = (PictureResourceAdapter)documentModel.getAdapter(PictureResourceAdapter.class);
            Blob blob = picture.getPictureFromTitle("Original");
            return blob;
        }
        finally {
            if (sessionOpened && session != null) {
                CoreInstance.getInstance().close(session);
            }
        }
    }

    public List<Blob> getBlobs() throws ClientException {
        return this.getBlobs("Original");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Blob> getBlobs(String title) throws ClientException {
        boolean sessionOpened = false;
        if (this.session == null) {
            sessionOpened = true;
            this.session = this.openNewSession();
        }
        try {
            DocumentModelList docList = this.session.getChildren(this.doc.getRef(), "Picture");
            ArrayList<Blob> blobList = new ArrayList<Blob>(docList.size());
            for (DocumentModel documentModel : docList) {
                PictureResourceAdapter picture = (PictureResourceAdapter)documentModel.getAdapter(PictureResourceAdapter.class);
                blobList.add(picture.getPictureFromTitle(title));
            }
            ArrayList<Blob> arrayList = blobList;
            return arrayList;
        }
        finally {
            if (sessionOpened && this.session != null) {
                CoreInstance.getInstance().close(this.session);
            }
        }
    }

    public String getHash() throws ClientException {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }

    protected CoreSession getSession() throws ClientException {
        if (this.session == null && this.doc != null) {
            this.session = this.doc.getCoreSession();
        }
        return this.session;
    }

    protected CoreSession openNewSession() throws ClientException {
        try {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            String repoName = null;
            if (this.doc != null) {
                repoName = this.doc.getRepositoryName();
            }
            if (repoName != null) {
                return rm.getRepository(repoName).open();
            }
            return rm.getDefaultRepository().open();
        }
        catch (Exception e) {
            throw new ClientException("Cannot get default repository ", (Throwable)e);
        }
    }
}

