/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.helper;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.jbpm.AbstractJbpmHandlerHelper;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;
import org.nuxeo.runtime.api.Framework;

public class SendEventActionHandler
extends AbstractJbpmHandlerHelper {
    private static final long serialVersionUID = 1L;
    protected static final String INITIATOR = "initiator";
    protected static final String PARTICIPANTS = "participants";
    private static final Log log = LogFactory.getLog(AbstractJbpmHandlerHelper.class);
    protected String eventName;
    protected String recipients;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) throws Exception {
        this.executionContext = executionContext;
        assert (this.eventName != null);
        assert (this.recipients != null);
        if (this.nuxeoHasStarted()) {
            DocumentModel documentModel = (DocumentModel)this.getTransientVariable(JbpmService.VariableName.document.name());
            NuxeoPrincipal principal = (NuxeoPrincipal)this.getTransientVariable(JbpmService.VariableName.principal.name());
            if (documentModel == null) {
                return;
            }
            CoreSession coreSession = this.getCoreSession(principal);
            try {
                EventProducer eventProducer = this.getEventProducerService();
                DocumentEventContext ctx = new DocumentEventContext(coreSession, (Principal)principal, documentModel);
                ctx.setProperty("recipients", (Serializable)this.getRecipients());
                eventProducer.fireEvent(ctx.newEvent(this.eventName));
            }
            finally {
                this.closeCoreSession(coreSession);
            }
        }
    }

    protected EventProducer getEventProducerService() throws ClientException {
        try {
            return (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected String[] getRecipients() {
        ArrayList<String> recipientsVal = new ArrayList<String>();
        if (this.recipients.equals(PARTICIPANTS)) {
            VirtualTaskInstance participant = (VirtualTaskInstance)this.executionContext.getContextInstance().getVariable(JbpmService.VariableName.participants.name());
            if (participant != null) {
                recipientsVal.addAll(participant.getActors());
            }
        } else if (this.recipients.equals(INITIATOR)) {
            String actorId = (String)this.executionContext.getContextInstance().getVariable(JbpmService.VariableName.initiator.name());
            recipientsVal.add(actorId);
        } else {
            log.info((Object)("Unknown recipient : " + this.recipients));
        }
        return recipientsVal.toArray(new String[0]);
    }
}

