/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.core.SortInfoDescriptor;
import org.nuxeo.ecm.platform.query.core.WhereClauseDescriptor;

@XObject(value="coreQueryPageProvider")
public class CoreQueryPageProviderDescriptor
implements PageProviderDefinition {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    String name;
    @XNode(value="@enabled")
    boolean enabled = true;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    Map<String, String> properties = new HashMap<String, String>();
    @XNodeList(value="parameter", type=String[].class, componentType=String.class)
    String[] queryParameters;
    @XNode(value="pageSize")
    long pageSize = 0L;
    @XNode(value="pageSizeBinding")
    String pageSizeBinding;
    @XNode(value="maxPageSize")
    Long maxPageSize;
    @XNode(value="sortable")
    boolean sortable = true;
    @XNodeList(value="sort", type=ArrayList.class, componentType=SortInfoDescriptor.class)
    List<SortInfoDescriptor> sortInfos;
    @XNode(value="sortInfosBinding")
    String sortInfosBinding;
    protected String pattern;
    @XNode(value="pattern@quoteParameters")
    protected boolean quotePatternParameters = true;
    @XNode(value="pattern@escapeParameters")
    protected boolean escapePatternParameters = true;
    @XNode(value="whereClause")
    protected WhereClauseDescriptor whereClause;

    @Override
    @XNode(value="pattern")
    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.replaceAll("\r?\n\\s*", " ");
        }
    }

    @Override
    public boolean getQuotePatternParameters() {
        return this.quotePatternParameters;
    }

    @Override
    public boolean getEscapePatternParameters() {
        return this.escapePatternParameters;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String[] getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public WhereClauseDefinition getWhereClause() {
        return this.whereClause;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> res = new ArrayList<SortInfo>();
        if (this.sortInfos != null) {
            for (SortInfoDescriptor sortInfo : this.sortInfos) {
                res.add(sortInfo.getSortInfo());
            }
        }
        return res;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getPageSizeBinding() {
        return this.pageSizeBinding;
    }

    @Override
    public String getSortInfosBinding() {
        return this.sortInfosBinding;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getMaxPageSize() {
        return this.maxPageSize;
    }
}

