/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.service;

import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.platform.wi.filter.SessionCacheHolder;
import org.nuxeo.ecm.platform.wi.filter.WISession;
import org.nuxeo.ecm.platform.wi.service.PluggableBackendFactory;
import org.nuxeo.ecm.platform.wi.service.WIService;

public class WIServiceImpl
implements WIService {
    @Override
    public String getPathById(String uuid, CoreSession session) throws ClientException {
        DocumentModel model = session.getDocument((DocumentRef)new IdRef(uuid));
        if (model == null) {
            return null;
        }
        String path = model.getPathAsString();
        Backend backend = this.getBackend(session);
        return backend.getVirtualPath(path);
    }

    @Override
    public void invalidateCache() {
        SessionCacheHolder.getInstance().getCache().invalidateCache();
    }

    private Backend getBackend(CoreSession session) {
        if (session == null) {
            return null;
        }
        Principal principal = session.getPrincipal();
        if (principal == null || StringUtils.isEmpty((String)principal.getName())) {
            return null;
        }
        String principalName = principal.getName();
        WISession wiSession = SessionCacheHolder.getInstance().getCache().get(principalName);
        wiSession.setAttribute("org.nuxeo.ecm.platform.wi.coresession", session);
        return new PluggableBackendFactory().getBackend(wiSession);
    }
}

