/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import com.sun.facelets.component.UIRepeat;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelectListboxComponent;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelectMultiListboxComponent;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.Selection;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntryList;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

public class ChainSelect
extends UIInput {
    public static final String COMPONENT_TYPE = "nxdirectory.chainSelect";
    public static final String COMPONENT_FAMILY = "nxdirectory.chainSelect";
    public static final String DEFAULT_KEY_SEPARATOR = "/";
    public static final String DEFAULT_PARENT_KEY = null;
    private static final Log log = LogFactory.getLog(ChainSelect.class);
    Map<Integer, NestedChainSelectComponentInfo> compInfos = new HashMap<Integer, NestedChainSelectComponentInfo>();
    private List<String> keyList = new ArrayList<String>();
    private String onchange;
    private Map<String, DirectorySelectItem>[] optionList;
    private Integer size;
    private boolean localize;
    private boolean multiSelect = false;
    private boolean allowRootSelection = false;
    private boolean allowBranchSelection = false;
    private boolean qualifiedParentKeys = false;
    private Selection[] selections;
    private Selection[] componentValue;
    private Boolean displayValueOnly;
    private String displayValueOnlyStyle;
    private String displayValueOnlyStyleClass;
    private String cssStyle;
    private String cssStyleClass;
    private boolean multiParentSelect = false;
    private int lastSelectedComponentIndex;
    private String keySeparator;
    protected String defaultRootKey;
    protected Boolean resetCacheOnUpdate;

    public boolean isAllowBranchSelection() {
        return this.allowBranchSelection;
    }

    public void setAllowBranchSelection(boolean allowBranchSelection) {
        this.allowBranchSelection = allowBranchSelection;
    }

    public boolean isAllowRootSelection() {
        return this.allowRootSelection;
    }

    public void setAllowRootSelection(boolean allowRootSelection) {
        this.allowRootSelection = allowRootSelection;
    }

    public String getFamily() {
        return "nxdirectory.chainSelect";
    }

    public String getRendererType() {
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.componentValue = (Selection[])values[1];
        this.optionList = (Map[])values[2];
        this.localize = (Boolean)values[3];
        this.size = (Integer)values[4];
        this.multiSelect = (Boolean)values[5];
        this.allowRootSelection = (Boolean)values[6];
        this.allowBranchSelection = (Boolean)values[7];
        this.selections = (Selection[])values[8];
        this.qualifiedParentKeys = (Boolean)values[9];
        this.displayValueOnly = (Boolean)values[10];
        this.displayValueOnlyStyle = (String)values[11];
        this.displayValueOnlyStyleClass = (String)values[12];
        this.multiParentSelect = (Boolean)values[13];
        this.cssStyle = (String)values[14];
        this.cssStyleClass = (String)values[15];
        this.keySeparator = (String)values[16];
        this.lastSelectedComponentIndex = (Integer)values[17];
        this.compInfos = (Map)values[18];
        this.keyList = (List)values[19];
        this.onchange = (String)values[20];
        this.defaultRootKey = (String)values[21];
        this.resetCacheOnUpdate = (Boolean)values[22];
    }

    public Object saveState(FacesContext arg0) {
        Object[] values = new Object[]{super.saveState(arg0), this.componentValue, this.optionList, this.localize, this.size, this.multiSelect, this.allowRootSelection, this.allowBranchSelection, this.selections, this.qualifiedParentKeys, this.displayValueOnly, this.displayValueOnlyStyle, this.displayValueOnlyStyleClass, this.multiParentSelect, this.cssStyle, this.cssStyleClass, this.keySeparator, this.lastSelectedComponentIndex, this.compInfos, this.keyList, this.onchange, this.defaultRootKey, this.resetCacheOnUpdate};
        return values;
    }

    public List<String> getSelectionKeyList() {
        return this.keyList;
    }

    public void addToSelectionKeyList(String key) {
        this.keyList.add(key);
    }

    public void decode(FacesContext context) {
        String[] value;
        if (this.getDisplayValueOnly().booleanValue()) {
            return;
        }
        this.setValid(true);
        this.rebuildOptions();
        if (!this.multiParentSelect) {
            this.componentValue = this.selections;
            value = this.encodeValue(this.componentValue);
            if (!this.multiSelect) {
                this.setSubmittedValue(value[0]);
            } else {
                if (!this.multiParentSelect) {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(value));
                    list.remove("");
                    value = list.toArray(new String[list.size()]);
                }
                this.setSubmittedValue(value);
            }
        } else {
            value = this.encodeValue(this.componentValue);
            this.setSubmittedValue(value);
        }
        List children = this.getChildren();
        for (UIComponent child : children) {
            UIRepeat component;
            if (!(child instanceof UIRepeat) || !(component = (UIRepeat)child).getId().equals("current_selections")) continue;
            component.setValue((Object)this.componentValue);
        }
    }

    public static String format(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof String[]) {
            return ChainSelect.formatAr((String[])o);
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.getClass().getName();
    }

    public static String formatAr(String[] ar) {
        if (ar == null) {
            return "NULL";
        }
        if (ar.length == 0) {
            return "[]";
        }
        return '[' + StringUtils.join((Object[])ar, (String)", ") + ']';
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.init();
        this.rebuildOptions();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)this);
        if (this.cssStyle != null) {
            writer.writeAttribute("style", (Object)this.cssStyle, "style");
        }
        if (this.cssStyleClass != null) {
            writer.writeAttribute("class", (Object)this.cssStyleClass, "class");
        }
        writer.writeAttribute("id", (Object)this.getClientId(context), "id");
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
    }

    public Object getProperty(String name) {
        ValueExpression ve = this.getValueExpression(name);
        if (ve != null) {
            try {
                return ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        Map attrMap = this.getAttributes();
        return attrMap.get(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String value = (String)this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public Boolean getBooleanProperty(String name, boolean defaultValue) {
        Boolean value = (Boolean)this.getProperty(name);
        return value != null ? value : Boolean.valueOf(defaultValue);
    }

    public Boolean getLocalize() {
        return this.localize;
    }

    public void setLocalize(Boolean localize) {
        this.localize = localize;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public String getCssStyleClass() {
        return this.cssStyleClass;
    }

    public void setCSsStyleClass(String cssStyleClass) {
        this.cssStyleClass = cssStyleClass;
    }

    public String getOnchange() {
        if (this.onchange != null) {
            return this.onchange;
        }
        ValueExpression ve = this.getValueExpression("onchange");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public Selection getSelection(int i) {
        if (this.selections == null) {
            throw new ClientRuntimeException("ChainSelect is mis-behaving, it's probable you're experiencing issue NXP-5762");
        }
        return this.selections[i];
    }

    public void setSelections(Selection[] sels) {
        this.selections = sels;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.optionList = new LinkedHashMap[size.intValue()];
        this.size = size;
    }

    public Map<String, DirectorySelectItem> getOptions(int index) {
        return this.optionList[index];
    }

    public void setOptions(int index, Map<String, DirectorySelectItem> opts) {
        this.optionList[index] = opts;
    }

    public void rebuildOptions() {
    }

    private void rebuildOptions(int index) {
        ChainSelectListboxComponent component = this.getComponent(index);
        if (component == null) {
            return;
        }
    }

    public ChainSelectListboxComponent getComponent(int i) {
        List children = this.getChildren();
        for (UIComponent child : children) {
            ChainSelectListboxComponent component;
            Integer index;
            if (!(child instanceof ChainSelectListboxComponent) || i != (index = (component = (ChainSelectListboxComponent)child).getIndex())) continue;
            return component;
        }
        for (UIComponent child : children) {
            if (child instanceof ChainSelectMultiListboxComponent) {
                ChainSelectMultiListboxComponent mcomp = (ChainSelectMultiListboxComponent)child;
                ChainSelectListboxComponent[] sComps = mcomp.createSingleComponents();
                if (i < sComps.length) {
                    return sComps[i];
                }
                log.error((Object)("xXXXXXXXXXXXXXXXXXXXX " + i));
            }
            if (!(child instanceof UIRepeat)) continue;
            List children2 = child.getChildren();
            for (UIComponent child2 : children2) {
                ChainSelectListboxComponent component;
                Integer index;
                if (!(child2 instanceof ChainSelectListboxComponent) || i != (index = (component = (ChainSelectListboxComponent)child2).getIndex())) continue;
                return component;
            }
        }
        return null;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public Selection[] getSelections() {
        return this.selections;
    }

    public boolean isQualifiedParentKeys() {
        return this.qualifiedParentKeys;
    }

    public void setQualifiedParentKeys(boolean fullyQualifiedParentKey) {
        this.qualifiedParentKeys = fullyQualifiedParentKey;
    }

    public Boolean getDisplayValueOnly() {
        if (this.displayValueOnly != null) {
            return this.displayValueOnly;
        }
        return false;
    }

    public void setDisplayValueOnly(Boolean displayValueOnly) {
        this.displayValueOnly = displayValueOnly;
    }

    public String getDisplayValueOnlyStyle() {
        return this.displayValueOnlyStyle;
    }

    public void setDisplayValueOnlyStyle(String displayValueOnlyStyle) {
        this.displayValueOnlyStyle = displayValueOnlyStyle;
    }

    public String getDisplayValueOnlyStyleClass() {
        return this.displayValueOnlyStyleClass;
    }

    public void setDisplayValueOnlyStyleClass(String displayValueOnlyStyleClass) {
        this.displayValueOnlyStyleClass = displayValueOnlyStyleClass;
    }

    public boolean getMultiParentSelect() {
        return this.multiParentSelect;
    }

    public void setMultiParentSelect(boolean multiParentSelect) {
        this.multiParentSelect = multiParentSelect;
        if (multiParentSelect) {
            this.multiSelect = true;
        }
    }

    public String[] encodeValue(Selection[] selections) {
        String[] keys = new String[selections.length];
        for (int i = 0; i < selections.length; ++i) {
            keys[i] = selections[i].getValue(this.keySeparator);
        }
        return keys;
    }

    private void init() {
        if (this.componentValue == null) {
            String[] rows;
            Object value = this.getValue();
            if (value == null) {
                this.componentValue = new Selection[0];
                this.selections = new Selection[1];
                this.selections[0] = new Selection(new DirectorySelectItem[0]);
                return;
            }
            if (this.multiSelect) {
                int i;
                if (value instanceof String[]) {
                    rows = (String[])value;
                } else if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    rows = new String[values.length];
                    for (i = 0; i < rows.length; ++i) {
                        rows[i] = String.valueOf(values[i]);
                    }
                } else if (value instanceof List) {
                    List valueList = (List)value;
                    rows = new String[valueList.size()];
                    for (i = 0; i < rows.length; ++i) {
                        rows[i] = String.valueOf(valueList.get(i));
                    }
                } else {
                    rows = new String[]{};
                }
            } else {
                rows = new String[]{(String)value};
            }
            this.componentValue = new Selection[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                String[] columns = StringUtils.split((String)rows[i], (String)this.getKeySeparator());
                this.componentValue[i] = this.createSelection(columns);
            }
            if (this.multiParentSelect) {
                this.selections = new Selection[1];
                this.selections[0] = new Selection(new DirectorySelectItem[0]);
            } else {
                this.selections = this.componentValue;
            }
        }
    }

    public Selection createSelection(List<String> columns) {
        return this.createSelection(columns.toArray(new String[columns.size()]));
    }

    public Selection createSelection(String[] columns) {
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<DirectorySelectItem> itemList = new ArrayList<DirectorySelectItem>();
        for (int i = 0; i < columns.length; ++i) {
            boolean displayObsoleteEntries;
            VocabularyEntryList directoryValues;
            String directoryName;
            String id = columns[i];
            NestedChainSelectComponentInfo compInfo = this.compInfos.get(i);
            if (compInfo != null) {
                directoryName = compInfo.directoryName;
                directoryValues = compInfo.directoryValues;
                displayObsoleteEntries = compInfo.displayObsoleteEntries;
            } else {
                ChainSelectListboxComponent comp = this.getComponent(i);
                directoryName = comp.getStringProperty("directoryName", null);
                directoryValues = comp.getDirectoryValues();
                displayObsoleteEntries = comp.getBooleanProperty("displayObsoleteEntries", false);
            }
            HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
            filter.put("id", (Serializable)((Object)id));
            if (i == 0) {
                if (directoryName != null && DirectoryHelper.instance().hasParentColumn(directoryName)) {
                    filter.put("parent", (Serializable)((Object)this.getDefaultRootKey()));
                }
            } else {
                String parentId = this.qualifiedParentKeys ? StringUtils.join(keyList.iterator(), (String)this.getKeySeparator()) : columns[i - 1];
                filter.put("parent", (Serializable)((Object)parentId));
            }
            keyList.add(id);
            if (!displayObsoleteEntries) {
                filter.put("obsolete", Integer.valueOf(0));
            }
            List<DirectorySelectItem> items = null;
            items = directoryName != null ? DirectoryHelper.instance().getSelectItems(directoryName, filter) : DirectoryHelper.getSelectItems(directoryValues, filter);
            if (items == null) {
                throw new IllegalStateException(String.format("Item not found: directoryName=%s, filter=%s", directoryName, filter));
            }
            if (items.isEmpty()) {
                log.warn((Object)String.format("No selection for dir %s ", directoryName));
                return new Selection(itemList.toArray(new DirectorySelectItem[0]));
            }
            if (items.size() != 1) {
                log.warn((Object)String.format("Too many items (%s) found: directoryName=%s, filter=%s", Integer.toString(items.size()), directoryName, filter));
            }
            itemList.add(items.get(0));
        }
        return new Selection(itemList.toArray(new DirectorySelectItem[columns.length]));
    }

    public Selection[] getComponentValue() {
        return this.componentValue;
    }

    public void setComponentValue(Selection[] componentValue) {
        this.componentValue = componentValue;
    }

    public int getLastSelectedComponentIndex() {
        return this.lastSelectedComponentIndex;
    }

    public void setLastSelectedComponentIndex(int index) {
        this.lastSelectedComponentIndex = index;
    }

    public void setCompAtIndex(int index, ChainSelectListboxComponent comp) {
        NestedChainSelectComponentInfo compInfo = new NestedChainSelectComponentInfo();
        compInfo.directoryName = comp.getStringProperty("directoryName", null);
        compInfo.directoryValues = comp.getDirectoryValues();
        compInfo.displayObsoleteEntries = comp.getBooleanProperty("displayObsoleteEntries", false);
        compInfo.localize = comp.getBooleanProperty("localize", false);
        compInfo.display = comp.getDisplay();
        this.compInfos.put(index, compInfo);
    }

    public String getKeySeparator() {
        return this.keySeparator != null ? this.keySeparator : DEFAULT_KEY_SEPARATOR;
    }

    public void setKeySeparator(String keySeparator) {
        this.keySeparator = keySeparator;
    }

    public String getDefaultRootKey() {
        return this.defaultRootKey;
    }

    public void setDefaultRootKey(String defaultRootKey) {
        this.defaultRootKey = defaultRootKey;
    }

    public void validateValue(FacesContext context, Object newValue) {
        super.validateValue(context, newValue);
        if (!this.isValid()) {
            return;
        }
        if (newValue instanceof String) {
            String newValueStr = (String)newValue;
            if (StringUtils.isEmpty((String)newValueStr)) {
                return;
            }
            String[] rows = StringUtils.split((String)newValueStr, (String)this.getKeySeparator());
            if (!this.allowBranchSelection && rows.length != this.size) {
                String messageStr = ComponentUtils.translate(context, "label.chainSelect.incomplete_selection");
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        }
    }

    public Boolean getResetCacheOnUpdate() {
        if (this.resetCacheOnUpdate != null) {
            return this.resetCacheOnUpdate;
        }
        ValueExpression ve = this.getValueExpression("resetCacheOnUpdate");
        if (ve != null) {
            try {
                return Boolean.TRUE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return Boolean.FALSE;
    }

    public void setResetCacheOnUpdate(Boolean resetCacheOnUpdate) {
        this.resetCacheOnUpdate = resetCacheOnUpdate;
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        if (Boolean.TRUE.equals(this.getResetCacheOnUpdate()) && this.isValid()) {
            this.componentValue = null;
        }
    }

    static class NestedChainSelectComponentInfo {
        String directoryName;
        VocabularyEntryList directoryValues;
        boolean displayObsoleteEntries;
        boolean localize;
        String display;

        NestedChainSelectComponentInfo() {
        }
    }
}

