/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class AclService {
    public static void getACL(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        Boolean onlyBasicPermissions = HttpUtils.getBooleanParameter(request, "onlyBasicPermissions");
        Acl acl = service.getAcl(repositoryId, objectId, onlyBasicPermissions, null);
        response.setStatus(201);
        JSONObject jsonObject = JSONConverter.convert((Acl)acl);
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void applyACL(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        AclPropagation aclPropagation = HttpUtils.getEnumParameter(request, "ACLPropagation", AclPropagation.class);
        ControlParser cp = new ControlParser(request);
        Acl acl = service.applyAcl(repositoryId, objectId, BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), aclPropagation, null);
        response.setStatus(201);
        JSONObject jsonObject = JSONConverter.convert((Acl)acl);
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }
}

