/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;
    private PhrasePositions[] repeats;
    private boolean checkedRepeats;

    SloppyPhraseScorer(Weight weight, TermPositions[] tps, int[] offsets, Similarity similarity, int slop, byte[] norms) {
        super(weight, tps, offsets, similarity, norms);
        this.slop = slop;
    }

    protected final float phraseFreq() throws IOException {
        boolean done;
        int end = this.initPhrasePositions();
        float freq = 0.0f;
        boolean bl = done = end < 0;
        while (!done) {
            int matchLength;
            PhrasePositions pp = (PhrasePositions)this.pq.pop();
            int start = pp.position;
            int next = ((PhrasePositions)this.pq.top()).position;
            boolean tpsDiffer = true;
            int pos = start;
            while (pos <= next || !tpsDiffer) {
                if (pos <= next && tpsDiffer) {
                    start = pos;
                }
                if (!pp.nextPosition()) {
                    done = true;
                    break;
                }
                tpsDiffer = !pp.repeats || this.termPositionsDiffer(pp);
                pos = pp.position;
            }
            if ((matchLength = end - start) <= this.slop) {
                freq += this.getSimilarity().sloppyFreq(matchLength);
            }
            if (pp.position > end) {
                end = pp.position;
            }
            this.pq.put(pp);
        }
        return freq;
    }

    private int initPhrasePositions() throws IOException {
        PhrasePositions pp;
        int end = 0;
        if (this.checkedRepeats && this.repeats == null) {
            this.pq.clear();
            PhrasePositions pp2 = this.first;
            while (pp2 != null) {
                pp2.firstPosition();
                if (pp2.position > end) {
                    end = pp2.position;
                }
                this.pq.put(pp2);
                pp2 = pp2.next;
            }
            return end;
        }
        PhrasePositions pp3 = this.first;
        while (pp3 != null) {
            pp3.firstPosition();
            pp3 = pp3.next;
        }
        if (!this.checkedRepeats) {
            this.checkedRepeats = true;
            HashMap<PhrasePositions, Object> m = null;
            pp = this.first;
            while (pp != null) {
                int tpPos = pp.position + pp.offset;
                PhrasePositions pp2 = pp.next;
                while (pp2 != null) {
                    int tpPos2 = pp2.position + pp2.offset;
                    if (tpPos2 == tpPos) {
                        if (m == null) {
                            m = new HashMap<PhrasePositions, Object>();
                        }
                        pp.repeats = true;
                        pp2.repeats = true;
                        m.put(pp, null);
                        m.put(pp2, null);
                    }
                    pp2 = pp2.next;
                }
                pp = pp.next;
            }
            if (m != null) {
                this.repeats = m.keySet().toArray(new PhrasePositions[0]);
            }
        }
        if (this.repeats != null) {
            Arrays.sort(this.repeats, new Comparator(){

                public int compare(Object x, Object y) {
                    return ((PhrasePositions)y).offset - ((PhrasePositions)x).offset;
                }
            });
            for (int i = 0; i < this.repeats.length; ++i) {
                pp = this.repeats[i];
                while (!this.termPositionsDiffer(pp)) {
                    if (pp.nextPosition()) continue;
                    return -1;
                }
            }
        }
        this.pq.clear();
        pp = this.first;
        while (pp != null) {
            if (pp.position > end) {
                end = pp.position;
            }
            this.pq.put(pp);
            pp = pp.next;
        }
        return end;
    }

    private boolean termPositionsDiffer(PhrasePositions pp) {
        int tpPos = pp.position + pp.offset;
        for (int i = 0; i < this.repeats.length; ++i) {
            int tpPos2;
            PhrasePositions pp2 = this.repeats[i];
            if (pp2 == pp || (tpPos2 = pp2.position + pp2.offset) != tpPos) continue;
            return false;
        }
        return true;
    }
}

