/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.NotificationImpl;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerHook;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NotificationEventListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(NotificationEventListener.class);
    private DocumentViewCodecManager docLocator;
    private UserManager userManager;
    private EmailHelper emailHelper = new EmailHelper();

    public void handleEvent(EventBundle events) throws ClientException {
        NotificationService service = NotificationServiceHelper.getNotificationService();
        if (service == null) {
            log.error((Object)"Unable to get NotificationService, exiting");
            return;
        }
        boolean processEvents = false;
        for (String name : service.getNotificationEventNames()) {
            if (!events.containsEventName(name)) continue;
            processEvents = true;
            break;
        }
        if (!processEvents) {
            return;
        }
        for (Event event : events) {
            List<Notification> notifs;
            Boolean block = (Boolean)event.getContext().getProperty("disableNotificationService");
            if (block != null && block.booleanValue() || (notifs = service.getNotificationsForEvents(event.getName())) == null || notifs.isEmpty()) continue;
            try {
                this.handleNotifications(event, notifs);
            }
            catch (Exception e) {
                log.error((Object)("Error during Notification processing for event " + event.getName()), (Throwable)e);
            }
        }
    }

    protected void handleNotifications(Event event, List<Notification> notifs) throws Exception {
        EventContext ctx = event.getContext();
        DocumentEventContext docCtx = null;
        if (!(ctx instanceof DocumentEventContext)) {
            log.warn((Object)"Can not handle notification on a event that is not bound to a DocumentEventContext");
            return;
        }
        docCtx = (DocumentEventContext)ctx;
        CoreSession coreSession = event.getContext().getCoreSession();
        Map properties = event.getContext().getProperties();
        HashMap<Notification, List<String>> targetUsers = new HashMap<Notification, List<String>>();
        for (NotificationListenerHook hookListener : NotificationServiceHelper.getNotificationService().getListenerHooks()) {
            docCtx = hookListener.handleNotifications(event);
        }
        this.gatherConcernedUsersForDocument(coreSession, docCtx.getSourceDocument(), notifs, targetUsers);
        for (Notification notif : targetUsers.keySet()) {
            if (!notif.getAutoSubscribed()) {
                for (String user : (List)targetUsers.get(notif)) {
                    this.sendNotificationSignalForUser(notif, user, event, docCtx);
                }
                continue;
            }
            Object recipientProperty = properties.get("recipients");
            String[] recipients = null;
            if (recipientProperty != null) {
                if (recipientProperty instanceof String[]) {
                    recipients = (String[])properties.get("recipients");
                } else if (recipientProperty instanceof String) {
                    recipients = new String[]{(String)recipientProperty};
                }
            }
            if (recipients == null) continue;
            HashSet<String> users = new HashSet<String>();
            for (String recipient : recipients) {
                if (recipient == null) continue;
                if (recipient.contains("user:")) {
                    users.add(recipient.replace("user:", ""));
                    continue;
                }
                if (recipient.contains("group:")) {
                    List<String> groupMembers = this.getGroupMembers(recipient.replace("group:", ""));
                    for (String member : groupMembers) {
                        users.add(member);
                    }
                    continue;
                }
                users.add(recipient);
            }
            for (String user : users) {
                this.sendNotificationSignalForUser(notif, user, event, docCtx);
            }
        }
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("UserManager service not deployed.", e);
            }
        }
        return this.userManager;
    }

    protected List<String> getGroupMembers(String groupId) throws ClientException {
        return this.getUserManager().getUsersInGroupAndSubGroups(groupId);
    }

    private void sendNotificationSignalForUser(Notification notification, String subscriptor, Event event, DocumentEventContext ctx) throws ClientException {
        log.debug((Object)"Producing notification message.");
        Map eventInfo = ctx.getProperties();
        eventInfo.put("destination", subscriptor);
        eventInfo.put("notification", notification);
        eventInfo.put("docId", ctx.getSourceDocument().getId());
        eventInfo.put("dateTime", new Date(event.getTime()));
        eventInfo.put("author", ctx.getPrincipal().getName());
        DocumentModel doc = ctx.getSourceDocument();
        if (!this.isDeleteEvent(event.getName())) {
            DocumentViewImpl docView = new DocumentViewImpl(doc);
            DocumentViewCodecManager docLocator = this.getDocLocator();
            if (docLocator != null) {
                eventInfo.put("docUrl", this.getDocLocator().getUrlFromDocumentView((DocumentView)docView, true, NotificationServiceHelper.getNotificationService().getServerUrlPrefix()));
            } else {
                eventInfo.put("docUrl", "");
            }
            eventInfo.put("docTitle", doc.getTitle());
        }
        if (this.isInterestedInNotification(notification)) {
            try {
                this.sendNotification(event, ctx);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("notification " + notification.getName() + " sent to " + notification.getSubject()));
                }
            }
            catch (ClientException e) {
                log.error((Object)"An error occurred while trying to send user notification", (Throwable)e);
            }
        }
    }

    public void sendNotification(Event event, DocumentEventContext ctx) throws ClientException {
        String eventId = event.getName();
        log.debug((Object)("Recieved a message for notification sender with eventId : " + eventId));
        Map eventInfo = ctx.getProperties();
        String userDest = (String)eventInfo.get("destination");
        NotificationImpl notif = (NotificationImpl)eventInfo.get("notification");
        NuxeoPrincipal recepient = NotificationServiceHelper.getUsersService().getPrincipal(userDest);
        if (recepient == null) {
            log.error((Object)("Couldn't find user: " + userDest + " to send her a mail."));
            return;
        }
        DataModel model = (DataModel)recepient.getModel().getDataModels().values().iterator().next();
        String email = (String)model.getData("email");
        if (email == null || "".equals(email)) {
            log.error((Object)("No email found for user: " + userDest));
            return;
        }
        String subjectTemplate = notif.getSubjectTemplate();
        String mailTemplate = notif.getTemplate();
        log.debug((Object)("email: " + email));
        log.debug((Object)("mail template: " + mailTemplate));
        log.debug((Object)("subject template: " + subjectTemplate));
        HashMap<String, Object> mail = new HashMap<String, Object>();
        mail.put("mail.to", email);
        String authorUsername = (String)eventInfo.get("author");
        if (authorUsername != null) {
            NuxeoPrincipal author = NotificationServiceHelper.getUsersService().getPrincipal(authorUsername);
            mail.put("principalAuthor", author);
        }
        mail.put("document", ctx.getSourceDocument());
        String subject = notif.getSubject() == null ? "notification" : notif.getSubject();
        subject = NotificationServiceHelper.getNotificationService().getEMailSubjectPrefix() + subject;
        mail.put("subject", subject);
        mail.put("template", mailTemplate);
        mail.put("subjectTemplate", subjectTemplate);
        Iterator i$ = eventInfo.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            mail.put(key, eventInfo.get(key = (String)i$.next()) == null ? "" : (Serializable)eventInfo.get(key));
            log.debug((Object)("Mail prop: " + key));
        }
        mail.put("eventId", eventId);
        try {
            this.emailHelper.sendmail(mail);
        }
        catch (MessagingException e) {
            log.warn((Object)("Failed to send notification email to '" + email + "': " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
        catch (Exception e) {
            throw new ClientException("Failed to send notification email ", (Throwable)e);
        }
    }

    private void gatherConcernedUsersForDocument(CoreSession coreSession, DocumentModel doc, List<Notification> notifs, Map<Notification, List<String>> targetUsers) throws Exception {
        if (doc.getPath().segmentCount() > 1) {
            log.debug((Object)("Searching document: " + doc.getName()));
            this.getInterstedUsers(doc, notifs, targetUsers);
            if (doc.getParentRef() != null && coreSession.exists(doc.getParentRef())) {
                DocumentModel parent = this.getDocumentParent(coreSession, doc);
                this.gatherConcernedUsersForDocument(coreSession, parent, notifs, targetUsers);
            }
        }
    }

    private DocumentModel getDocumentParent(CoreSession coreSession, DocumentModel doc) throws ClientException {
        if (doc == null) {
            return null;
        }
        return coreSession.getDocument(doc.getParentRef());
    }

    private void getInterstedUsers(DocumentModel doc, List<Notification> notifs, Map<Notification, List<String>> targetUsers) throws Exception {
        for (Notification notification : notifs) {
            if (!notification.getAutoSubscribed()) {
                List<String> userGroup = NotificationServiceHelper.getNotificationService().getSubscribers(notification.getName(), doc.getId());
                for (String subscriptor : userGroup) {
                    if (subscriptor == null) continue;
                    if (this.isUser(subscriptor)) {
                        NotificationEventListener.storeUserForNotification(notification, subscriptor.substring(5), targetUsers);
                        continue;
                    }
                    List<String> usersOfGroup = this.getGroupMembers(subscriptor.substring(6));
                    if (usersOfGroup == null || usersOfGroup.isEmpty()) continue;
                    for (String usr : usersOfGroup) {
                        NotificationEventListener.storeUserForNotification(notification, usr, targetUsers);
                    }
                }
                continue;
            }
            targetUsers.put(notification, new ArrayList());
        }
    }

    private static void storeUserForNotification(Notification notification, String user, Map<Notification, List<String>> targetUsers) {
        List<String> subscribedUsers = targetUsers.get(notification);
        if (subscribedUsers == null) {
            targetUsers.put(notification, new ArrayList());
        }
        if (!targetUsers.get(notification).contains(user)) {
            targetUsers.get(notification).add(user);
        }
    }

    private boolean isDeleteEvent(String eventId) {
        ArrayList<String> deletionEvents = new ArrayList<String>();
        deletionEvents.add("aboutToRemove");
        deletionEvents.add("documentRemoved");
        return deletionEvents.contains(eventId);
    }

    private boolean isUser(String subscriptor) {
        return subscriptor != null && subscriptor.startsWith("user:");
    }

    public boolean isInterestedInNotification(Notification notif) {
        return notif != null && "email".equals(notif.getChannel());
    }

    public DocumentViewCodecManager getDocLocator() {
        if (this.docLocator == null) {
            try {
                this.docLocator = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
                if (this.docLocator == null) {
                    log.warn((Object)"Could not get service for document view manager");
                }
            }
            catch (Exception e) {
                log.info((Object)"Could not get service for document view manager");
            }
        }
        return this.docLocator;
    }

    public EmailHelper getEmailHelper() {
        return this.emailHelper;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }
}

