/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.rules;

import java.util.Arrays;
import java.util.HashSet;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.publisher.rules.PublishingValidatorException;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;

public class DefaultValidatorsRule
implements ValidatorsRule {
    private static final long serialVersionUID = 1L;

    public String[] computesValidatorsFor(DocumentModel doc) throws PublishingValidatorException {
        UnrestrictedACPGetter acpg = new UnrestrictedACPGetter(doc);
        try {
            acpg.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingValidatorException((Throwable)e);
        }
        String[] writePermissions = doc.getCoreSession().getPermissionsToCheck("Write");
        String[] reviewers = acpg.acp.listUsernamesForAnyPermission(new HashSet<String>(Arrays.asList(writePermissions)));
        return reviewers;
    }

    protected static class UnrestrictedACPGetter
    extends UnrestrictedSessionRunner {
        public final DocumentRef docRef;
        public ACP acp;

        public UnrestrictedACPGetter(DocumentModel doc) {
            super(doc.getCoreSession());
            this.docRef = doc.getRef();
        }

        public void run() throws ClientException {
            this.acp = this.session.getACP(this.docRef);
        }
    }
}

