/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.NoSuchPropertyException;
import org.nuxeo.ecm.core.versioning.DefaultVersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.ExtendableVersioningService;
import org.nuxeo.ecm.core.versioning.InitialStateDescriptor;
import org.nuxeo.ecm.core.versioning.SaveOptionsDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRuleDescriptor;

public class StandardVersioningService
implements ExtendableVersioningService {
    private static final Log log = LogFactory.getLog(StandardVersioningService.class);
    public static final String FILE_TYPE = "File";
    public static final String NOTE_TYPE = "Note";
    public static final String PROJECT_STATE = "project";
    public static final String APPROVED_STATE = "approved";
    public static final String OBSOLETE_STATE = "obsolete";
    public static final String BACK_TO_PROJECT_TRANSITION = "backToProject";
    protected static final String AUTO_CHECKED_OUT = "AUTO_CHECKED_OUT";
    protected static final String MAJOR_VERSION = "major_version";
    protected static final String MINOR_VERSION = "minor_version";
    private Map<String, VersioningRuleDescriptor> versioningRules;
    private DefaultVersioningRuleDescriptor defaultVersioningRule;

    @Override
    public String getVersionLabel(DocumentModel docModel) {
        String label;
        try {
            label = this.getMajor(docModel) + "." + this.getMinor(docModel);
            if (docModel.isCheckedOut() && !"0.0".equals(label)) {
                label = label + "+";
            }
        }
        catch (PropertyNotFoundException e) {
            label = "";
        }
        catch (ClientException e) {
            log.debug((Object)"No version label", (Throwable)e);
            label = "";
        }
        return label;
    }

    protected long getMajor(DocumentModel docModel) throws ClientException {
        return this.getVersion(docModel, "uid:major_version");
    }

    protected long getMinor(DocumentModel docModel) throws ClientException {
        return this.getVersion(docModel, "uid:minor_version");
    }

    protected long getVersion(DocumentModel docModel, String prop) throws ClientException {
        Serializable propVal = docModel.getPropertyValue(prop);
        if (propVal == null || !(propVal instanceof Long)) {
            return 0L;
        }
        return (Long)propVal;
    }

    protected long getMajor(Document doc) throws DocumentException {
        return this.getVersion(doc, MAJOR_VERSION);
    }

    protected long getMinor(Document doc) throws DocumentException {
        return this.getVersion(doc, MINOR_VERSION);
    }

    protected long getVersion(Document doc, String prop) throws DocumentException {
        Object propVal = doc.getPropertyValue(prop);
        if (propVal == null || !(propVal instanceof Long)) {
            return 0L;
        }
        return (Long)propVal;
    }

    protected void setVersion(Document doc, long major, long minor) throws DocumentException {
        doc.setPropertyValue(MAJOR_VERSION, major);
        doc.setPropertyValue(MINOR_VERSION, minor);
    }

    protected void incrementMajor(Document doc) throws DocumentException {
        this.setVersion(doc, this.getMajor(doc) + 1L, 0L);
    }

    protected void incrementMinor(Document doc) throws DocumentException {
        doc.setPropertyValue(MINOR_VERSION, this.getMinor(doc) + 1L);
    }

    protected void incrementByOption(Document doc, VersioningOption option) throws DocumentException {
        try {
            if (option == VersioningOption.MAJOR) {
                this.incrementMajor(doc);
            } else if (option == VersioningOption.MINOR) {
                this.incrementMinor(doc);
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
    }

    @Override
    public void doPostCreate(Document doc, Map<String, Serializable> options) {
        if (doc.isVersion() || doc.isProxy()) {
            return;
        }
        try {
            this.setInitialVersion(doc);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    protected void setInitialVersion(Document doc) throws DocumentException {
        VersioningRuleDescriptor versionRule;
        InitialStateDescriptor initialState = null;
        if (this.versioningRules != null && (versionRule = this.versioningRules.get(doc.getType().getName())) != null) {
            initialState = versionRule.getInitialState();
        }
        if (initialState == null && this.defaultVersioningRule != null) {
            initialState = this.defaultVersioningRule.getInitialState();
        }
        if (initialState != null) {
            int initialMajor = initialState.getMajor();
            int initialMinor = initialState.getMinor();
            this.setVersion(doc, initialMajor, initialMinor);
            return;
        }
        this.setVersion(doc, 0L, 0L);
    }

    @Override
    public List<VersioningOption> getSaveOptions(DocumentModel docModel) throws ClientException {
        String lifecycleState;
        boolean versionable = docModel.isVersionable();
        try {
            lifecycleState = docModel.getCoreSession().getCurrentLifeCycleState(docModel.getRef());
        }
        catch (ClientException e) {
            lifecycleState = null;
        }
        String type = docModel.getType();
        return this.getSaveOptions(versionable, lifecycleState, type);
    }

    protected List<VersioningOption> getSaveOptions(Document doc) throws DocumentException {
        String lifecycleState;
        boolean versionable = doc.getType().getFacets().contains("Versionable");
        try {
            lifecycleState = doc.getLifeCycleState();
        }
        catch (LifeCycleException e) {
            lifecycleState = null;
        }
        String type = doc.getType().getName();
        return this.getSaveOptions(versionable, lifecycleState, type);
    }

    protected List<VersioningOption> getSaveOptions(boolean versionable, String lifecycleState, String type) {
        VersioningRuleDescriptor saveOption;
        if (!versionable) {
            return Arrays.asList(VersioningOption.NONE);
        }
        if (lifecycleState == null) {
            return Arrays.asList(VersioningOption.NONE);
        }
        SaveOptionsDescriptor option = null;
        if (this.versioningRules != null && (saveOption = this.versioningRules.get(type)) != null && (option = saveOption.getOptions().get(lifecycleState)) == null) {
            option = saveOption.getOptions().get("*");
        }
        if (option == null && this.defaultVersioningRule != null && (option = this.defaultVersioningRule.getOptions().get(lifecycleState)) == null) {
            option = this.defaultVersioningRule.getOptions().get("*");
        }
        if (option != null) {
            return option.getVersioningOptionList();
        }
        if (PROJECT_STATE.equals(lifecycleState) || APPROVED_STATE.equals(lifecycleState) || OBSOLETE_STATE.equals(lifecycleState)) {
            return Arrays.asList(VersioningOption.NONE, VersioningOption.MINOR, VersioningOption.MAJOR);
        }
        if (FILE_TYPE.equals(type) || NOTE_TYPE.equals(type)) {
            return Arrays.asList(VersioningOption.NONE, VersioningOption.MINOR, VersioningOption.MAJOR);
        }
        return Arrays.asList(VersioningOption.NONE);
    }

    protected VersioningOption validateOption(Document doc, VersioningOption option) throws DocumentException {
        List<VersioningOption> options = this.getSaveOptions(doc);
        if (!options.contains(option)) {
            option = options.get(0);
        }
        return option;
    }

    @Override
    public VersioningOption doPreSave(Document doc, boolean isDirty, VersioningOption option, String checkinComment, Map<String, Serializable> options) throws DocumentException {
        option = this.validateOption(doc, option);
        if (!doc.isCheckedOut() && isDirty) {
            this.doCheckOut(doc);
            this.followTransitionByOption(doc, option);
        }
        return option;
    }

    protected void followTransitionByOption(Document doc, VersioningOption option) throws DocumentException {
        try {
            String lifecycleState = doc.getLifeCycleState();
            if (APPROVED_STATE.equals(lifecycleState) || OBSOLETE_STATE.equals(lifecycleState)) {
                doc.followTransition(BACK_TO_PROJECT_TRANSITION);
            }
        }
        catch (LifeCycleException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    @Override
    public Document doPostSave(Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) throws DocumentException {
        boolean increment;
        boolean bl = increment = option != VersioningOption.NONE;
        if (doc.isCheckedOut() && increment) {
            this.incrementByOption(doc, option);
            return doc.checkIn(null, checkinComment);
        }
        return null;
    }

    @Override
    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) throws DocumentException {
        this.incrementByOption(doc, option == VersioningOption.MAJOR ? VersioningOption.MAJOR : VersioningOption.MINOR);
        return doc.checkIn(null, checkinComment);
    }

    @Override
    public void doCheckOut(Document doc) throws DocumentException {
        doc.checkOut();
        try {
            Document last = doc.getLastVersion();
            if (last != null) {
                this.setVersion(doc, this.getMajor(last), this.getMinor(last));
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
    }

    @Override
    public Map<String, VersioningRuleDescriptor> getVersioningRules() {
        return this.versioningRules;
    }

    @Override
    public void setVersioningRules(Map<String, VersioningRuleDescriptor> versioningRules) {
        this.versioningRules = versioningRules;
    }

    @Override
    public void setDefaultVersioningRule(DefaultVersioningRuleDescriptor defaultVersioningRule) {
        this.defaultVersioningRule = defaultVersioningRule;
    }
}

