/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewDescriptor;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewImpl;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayoutImpl;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewStateImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.ReferencePageProviderDescriptor;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentViewServiceImpl
extends DefaultComponent
implements ContentViewService {
    public static final String CONTENT_VIEW_EP = "contentViews";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContentViewServiceImpl.class);
    protected final Map<String, ContentViewDescriptor> contentViews = new HashMap<String, ContentViewDescriptor>();
    protected final Map<String, Set<String>> contentViewsByFlag = new HashMap<String, Set<String>>();

    @Override
    public ContentView getContentView(String name) throws ClientException {
        Boolean showFilterForm;
        Boolean showRefreshPage;
        Boolean showPageSizeSelector;
        Boolean showTitle;
        Boolean translateEmptySentence;
        Boolean translateTitle;
        ContentViewDescriptor desc = this.contentViews.get(name);
        if (desc == null) {
            return null;
        }
        Boolean useGlobalPageSize = desc.getUseGlobalPageSize();
        if (useGlobalPageSize == null) {
            useGlobalPageSize = Boolean.FALSE;
        }
        if ((translateTitle = desc.getTranslateTitle()) == null) {
            translateTitle = Boolean.FALSE;
        }
        if ((translateEmptySentence = desc.getTranslateEmptySentence()) == null) {
            translateEmptySentence = Boolean.FALSE;
        }
        if ((showTitle = desc.getShowTitle()) == null) {
            showTitle = Boolean.FALSE;
        }
        if ((showPageSizeSelector = desc.getShowPageSizeSelector()) == null) {
            showPageSizeSelector = Boolean.FALSE;
        }
        if ((showRefreshPage = desc.getShowRefreshCommand()) == null) {
            showRefreshPage = Boolean.TRUE;
        }
        if ((showFilterForm = desc.getShowFilterForm()) == null) {
            showFilterForm = Boolean.FALSE;
        }
        String[] queryParams = null;
        String searchDocumentType = null;
        String sortInfosBinding = null;
        String pageSizeBinding = null;
        CoreQueryPageProviderDescriptor coreDesc = desc.getCoreQueryPageProvider();
        GenericPageProviderDescriptor genDesc = desc.getGenericPageProvider();
        ReferencePageProviderDescriptor refDesc = desc.getReferencePageProvider();
        String[] refQueryParams = null;
        if (refDesc != null && refDesc.isEnabled()) {
            try {
                PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
                PageProviderDefinition def = ppService.getPageProviderDefinition(refDesc.getName());
                if (def == null) {
                    log.error((Object)("Could not resolve page provider with name " + refDesc.getName()));
                } else if (def instanceof CoreQueryPageProviderDescriptor) {
                    coreDesc = (CoreQueryPageProviderDescriptor)def;
                    refQueryParams = refDesc.getQueryParameters();
                } else if (def instanceof GenericPageProviderDescriptor) {
                    genDesc = (GenericPageProviderDescriptor)def;
                    refQueryParams = refDesc.getQueryParameters();
                }
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        WhereClauseDefinition whereClause = null;
        if (coreDesc != null && coreDesc.isEnabled()) {
            whereClause = coreDesc.getWhereClause();
            queryParams = coreDesc.getQueryParameters();
            sortInfosBinding = coreDesc.getSortInfosBinding();
            pageSizeBinding = coreDesc.getPageSizeBinding();
        } else if (genDesc != null && genDesc.isEnabled()) {
            whereClause = genDesc.getWhereClause();
            queryParams = genDesc.getQueryParameters();
            sortInfosBinding = genDesc.getSortInfosBinding();
            pageSizeBinding = genDesc.getPageSizeBinding();
        }
        if (whereClause != null) {
            searchDocumentType = whereClause.getDocType();
        }
        ArrayList<String> allQueryParams = new ArrayList<String>();
        if (queryParams != null) {
            allQueryParams.addAll(Arrays.asList(queryParams));
        }
        if (refQueryParams != null) {
            allQueryParams.addAll(Arrays.asList(refQueryParams));
        }
        String searchDocBinding = desc.getSearchDocumentBinding();
        ContentViewImpl contentView = new ContentViewImpl(name, desc.getTitle(), translateTitle, desc.getIconPath(), desc.getSelectionListName(), desc.getPagination(), desc.getActionCategories(), desc.getSearchLayout(), desc.getResultLayouts(), desc.getFlags(), desc.getCacheKey(), desc.getCacheSize(), desc.getRefreshEventNames(), desc.getResetEventNames(), useGlobalPageSize, allQueryParams.toArray(new String[0]), searchDocBinding, searchDocumentType, desc.getResultColumnsBinding(), sortInfosBinding, pageSizeBinding, showTitle, showPageSizeSelector, showRefreshPage, showFilterForm, desc.getEmptySentence(), translateEmptySentence);
        return contentView;
    }

    protected ContentViewHeader getContentViewHeader(ContentViewDescriptor desc) {
        return new ContentViewHeader(desc.getName(), desc.getTitle(), Boolean.TRUE.equals(desc.getTranslateTitle()), desc.getIconPath());
    }

    @Override
    public ContentViewHeader getContentViewHeader(String name) {
        ContentViewDescriptor desc = this.contentViews.get(name);
        if (desc == null) {
            return null;
        }
        return this.getContentViewHeader(desc);
    }

    @Override
    public Set<String> getContentViewNames() {
        return Collections.unmodifiableSet(this.contentViews.keySet());
    }

    @Override
    public Set<ContentViewHeader> getContentViewHeaders() {
        HashSet<ContentViewHeader> res = new HashSet<ContentViewHeader>();
        for (ContentViewDescriptor desc : this.contentViews.values()) {
            res.add(this.getContentViewHeader(desc));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<String> getContentViewNames(String flag) {
        HashSet<String> res = new HashSet<String>();
        Set<String> items = this.contentViewsByFlag.get(flag);
        if (items != null) {
            res.addAll(items);
        }
        return res;
    }

    @Override
    public Set<ContentViewHeader> getContentViewHeaders(String flag) {
        Set<String> cvs = this.getContentViewNames(flag);
        HashSet<ContentViewHeader> res = new HashSet<ContentViewHeader>();
        for (String cv : cvs) {
            ContentViewHeader header = this.getContentViewHeader(cv);
            if (header == null) continue;
            res.add(header);
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Object ... parameters) throws ClientException {
        ContentViewDescriptor contentViewDesc = this.contentViews.get(name);
        if (contentViewDesc == null) {
            return null;
        }
        PageProviderService ppService = null;
        try {
            ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        if (ppService == null) {
            throw new ClientException("Page provider service is null");
        }
        CoreQueryPageProviderDescriptor coreDesc = contentViewDesc.getCoreQueryPageProvider();
        GenericPageProviderDescriptor genDesc = contentViewDesc.getGenericPageProvider();
        ReferencePageProviderDescriptor refDesc = contentViewDesc.getReferencePageProvider();
        if (coreDesc != null && coreDesc.isEnabled() && genDesc != null && genDesc.isEnabled() && refDesc != null && refDesc.isEnabled()) {
            log.error((Object)String.format("Only one page provider should be registered on content view '%s': take the reference descriptor by default, then core query descriptor, and then generic descriptor", name));
        }
        PageProvider provider = null;
        if (refDesc != null && refDesc.isEnabled()) {
            try {
                PageProviderDefinition def = ppService.getPageProviderDefinition(refDesc.getName());
                if (def == null) {
                    log.error((Object)("Could not resolve page provider with name " + refDesc.getName()));
                }
                provider = ppService.getPageProvider(refDesc.getName(), sortInfos, pageSize, currentPage, this.resolvePageProviderProperties(refDesc.getProperties()), parameters);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        } else if (coreDesc != null && coreDesc.isEnabled()) {
            provider = ppService.getPageProvider(name, (PageProviderDefinition)coreDesc, sortInfos, pageSize, currentPage, this.resolvePageProviderProperties(coreDesc.getProperties()), parameters);
        } else if (genDesc != null && genDesc.isEnabled()) {
            provider = ppService.getPageProvider(name, (PageProviderDefinition)genDesc, sortInfos, pageSize, currentPage, this.resolvePageProviderProperties(genDesc.getProperties()), parameters);
        }
        return provider;
    }

    public Map<String, Serializable> resolvePageProviderProperties(Map<String, String> stringProps) throws ClientException {
        try {
            HashMap<String, Serializable> resolvedProps = new HashMap<String, Serializable>();
            for (Map.Entry<String, String> prop : stringProps.entrySet()) {
                resolvedProps.put(prop.getKey(), this.resolveProperty(prop.getValue()));
            }
            return resolvedProps;
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected Serializable resolveProperty(String elExpression) {
        FacesContext context = FacesContext.getCurrentInstance();
        Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)elExpression);
        if (value != null && !(value instanceof Serializable)) {
            log.error((Object)String.format("Error processing expression '%s', result is not serializable: %s", elExpression, value));
            return null;
        }
        return (Serializable)value;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(ContentViewService.class)) {
            return (T)this;
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONTENT_VIEW_EP.equals(extensionPoint)) {
            ContentViewDescriptor desc = (ContentViewDescriptor)contribution;
            String name = desc.getName();
            if (name == null) {
                log.error((Object)"Cannot register content view without a name");
                return;
            }
            boolean enabled = desc.isEnabled();
            if (this.contentViews.containsKey(name)) {
                log.info((Object)("Overriding content view with name " + name));
                ContentViewDescriptor oldDesc = this.contentViews.get(name);
                this.removeContentViewFlags(oldDesc);
                if (enabled) {
                    desc = this.mergeContentViews(oldDesc, desc);
                } else {
                    this.contentViews.remove(name);
                    log.info((Object)("Disabled content view with name " + name));
                }
            }
            if (enabled) {
                log.info((Object)("Registering content view with name " + name));
                this.contentViews.put(name, desc);
                this.addContentViewFlags(desc);
            }
        }
    }

    protected ContentViewDescriptor mergeContentViews(ContentViewDescriptor oldDesc, ContentViewDescriptor newDesc) {
        String searchDocument;
        Boolean showFilterForm;
        Boolean showRefreshCommand;
        Boolean showPageSizeSelector;
        Boolean useGlobalPageSize;
        String selectionList;
        List<String> flags;
        List<ContentViewLayout> resultLayouts;
        ContentViewLayoutImpl searchLayout;
        List<String> events;
        String pagination;
        GenericPageProviderDescriptor genDesc;
        CoreQueryPageProviderDescriptor coreDesc;
        Integer cacheSize;
        String cacheKey;
        List<String> actions;
        String iconPath;
        Boolean translateTitle;
        String title = newDesc.getTitle();
        if (title != null) {
            oldDesc.title = title;
        }
        if ((translateTitle = newDesc.getTranslateTitle()) != null) {
            oldDesc.translateTitle = translateTitle;
        }
        if ((iconPath = newDesc.getIconPath()) != null) {
            oldDesc.iconPath = iconPath;
        }
        if ((actions = newDesc.getActionCategories()) != null && !actions.isEmpty()) {
            oldDesc.actionCategories = actions;
        }
        if ((cacheKey = newDesc.getCacheKey()) != null) {
            oldDesc.cacheKey = cacheKey;
        }
        if ((cacheSize = newDesc.getCacheSize()) != null) {
            oldDesc.cacheSize = cacheSize;
        }
        if ((coreDesc = newDesc.getCoreQueryPageProvider()) != null && coreDesc.isEnabled()) {
            oldDesc.coreQueryPageProvider = coreDesc;
        }
        if ((genDesc = newDesc.getGenericPageProvider()) != null && genDesc.isEnabled()) {
            oldDesc.genericPageProvider = genDesc;
        }
        if ((pagination = newDesc.getPagination()) != null) {
            oldDesc.pagination = pagination;
        }
        if ((events = newDesc.getRefreshEventNames()) != null && !events.isEmpty()) {
            oldDesc.refreshEventNames = events;
        }
        if ((events = newDesc.getResetEventNames()) != null && !events.isEmpty()) {
            oldDesc.resetEventNames = events;
        }
        if ((searchLayout = newDesc.getSearchLayout()) != null) {
            oldDesc.searchLayout = searchLayout;
        }
        if ((resultLayouts = newDesc.getResultLayouts()) != null) {
            Boolean appendResultLayout = newDesc.appendResultLayouts;
            if (Boolean.TRUE.equals(appendResultLayout)) {
                ArrayList<ContentViewLayout> allLayouts = new ArrayList<ContentViewLayout>();
                if (oldDesc.resultLayouts != null) {
                    allLayouts.addAll(oldDesc.resultLayouts);
                }
                allLayouts.addAll(resultLayouts);
                oldDesc.resultLayouts = allLayouts;
            } else {
                oldDesc.resultLayouts = resultLayouts;
            }
        }
        if ((flags = newDesc.getFlags()) != null && !flags.isEmpty()) {
            oldDesc.flags = flags;
        }
        if ((selectionList = newDesc.getSelectionListName()) != null) {
            oldDesc.selectionList = selectionList;
        }
        if ((useGlobalPageSize = newDesc.getUseGlobalPageSize()) != null) {
            oldDesc.useGlobalPageSize = useGlobalPageSize;
        }
        if ((showPageSizeSelector = newDesc.getShowPageSizeSelector()) != null) {
            oldDesc.showPageSizeSelector = showPageSizeSelector;
        }
        if ((showRefreshCommand = newDesc.getShowRefreshCommand()) != null) {
            oldDesc.showRefreshCommand = showRefreshCommand;
        }
        if ((showFilterForm = newDesc.getShowFilterForm()) != null) {
            oldDesc.showFilterForm = showFilterForm;
        }
        if ((searchDocument = newDesc.getSearchDocumentBinding()) != null) {
            oldDesc.searchDocument = searchDocument;
        }
        return oldDesc;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONTENT_VIEW_EP.equals(extensionPoint)) {
            ContentViewDescriptor desc = (ContentViewDescriptor)contribution;
            String name = desc.getName();
            this.contentViews.remove(name);
            this.removeContentViewFlags(desc);
            log.info((Object)("Unregistering content view with name " + name));
        }
    }

    protected void addContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) {
                    items = new HashSet<String>();
                }
                items.add(name);
                this.contentViewsByFlag.put(flag, items);
            }
        }
    }

    protected void removeContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) continue;
                items.remove(name);
                this.contentViewsByFlag.put(flag, items);
            }
        }
    }

    @Override
    public ContentView restoreContentView(ContentViewState contentViewState) throws ClientException {
        DocumentModel searchDocument;
        Long pageSize;
        if (contentViewState == null) {
            return null;
        }
        String name = contentViewState.getContentViewName();
        ContentView cv = this.getContentView(name);
        if (cv != null) {
            pageSize = contentViewState.getPageSize();
            cv.setCurrentPageSize(pageSize);
            searchDocument = contentViewState.getSearchDocumentModel();
            cv.setSearchDocumentModel(searchDocument);
            if (searchDocument != null) {
                String searchType = cv.getSearchDocumentModelType();
                if (!searchDocument.getType().equals(searchType)) {
                    log.warn((Object)String.format("Restored document type '%s' is different from the one declared on content view with name '%s': should be '%s'", searchDocument.getType(), name, searchType));
                }
            }
        } else {
            throw new ClientException(String.format("Unknown content view with name '%s'", name));
        }
        Long currentPage = contentViewState.getCurrentPage();
        Object[] params = contentViewState.getQueryParameters();
        cv.getPageProvider(searchDocument, contentViewState.getSortInfos(), pageSize, currentPage, params);
        cv.setCurrentResultLayout(contentViewState.getResultLayout());
        cv.setCurrentResultLayoutColumns(contentViewState.getResultColumns());
        return cv;
    }

    @Override
    public ContentViewState saveContentView(ContentView contentView) {
        if (contentView == null) {
            return null;
        }
        ContentViewStateImpl state = new ContentViewStateImpl();
        state.setContentViewName(contentView.getName());
        state.setPageSize(contentView.getCurrentPageSize());
        PageProvider<?> pp = contentView.getCurrentPageProvider();
        if (pp != null) {
            state.setSearchDocumentModel(pp.getSearchDocumentModel());
            state.setCurrentPage(new Long(pp.getCurrentPageIndex()));
            state.setQueryParameters(pp.getParameters());
            state.setSortInfos(pp.getSortInfos());
        } else {
            state.setSearchDocumentModel(contentView.getSearchDocumentModel());
            state.setQueryParameters(contentView.getQueryParameters());
        }
        state.setResultLayout(contentView.getCurrentResultLayout());
        state.setResultColumns(contentView.getCurrentResultLayoutColumns());
        return state;
    }
}

