/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.nuxeo.connect.client.status.ConnectStatusHolder;
import org.nuxeo.connect.client.ui.SharedPackageListingsSettings;
import org.nuxeo.connect.client.vindoz.InstallAfterRestart;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.SubscriptionStatusType;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="packageListingProvider")
public class PackageListingProvider
extends DefaultObject {
    public String getConnectBaseUrl() {
        return ConnectUrlConfig.getBaseUrl();
    }

    protected List<DownloadablePackage> filterOnPlatform(List<DownloadablePackage> pkgs, Boolean filterOnPlatform) {
        if (filterOnPlatform == null || !filterOnPlatform.booleanValue()) {
            return pkgs;
        }
        String targetPF = PlatformVersionHelper.getPlatformFilter();
        if (targetPF == null) {
            return pkgs;
        }
        ArrayList<DownloadablePackage> filteredPackages = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : pkgs) {
            if (!PlatformVersionHelper.isCompatible(pkg.getTargetPlatforms())) continue;
            filteredPackages.add(pkg);
        }
        return filteredPackages;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="list")
    public Object doList(@QueryParam(value="type") String type, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        List pkgs = type == null || "".equals(type.trim()) ? pm.listPackages() : pm.listPackages(PackageType.getByValue((String)type));
        pkgs = this.filterOnPlatform(pkgs, filterOnPlatform);
        return this.getView("simpleListing").arg("pkgs", (Object)pkgs).arg("showCommunityInfo", (Object)true).arg("source", (Object)"list");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="updates")
    public Object getUpdates(@QueryParam(value="type") String type, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (type == null) {
            type = SharedPackageListingsSettings.instance().get("updates").getPackageTypeFilter();
        }
        if (filterOnPlatform == null) {
            filterOnPlatform = SharedPackageListingsSettings.instance().get("updates").getPlatformFilter();
        }
        List pkgs = type == null || "".equals(type.trim()) ? pm.listUpdatePackages() : pm.listUpdatePackages(PackageType.getByValue((String)type));
        pkgs = this.filterOnPlatform(pkgs, filterOnPlatform);
        return this.getView("simpleListing").arg("pkgs", (Object)pkgs).arg("showCommunityInfo", (Object)true).arg("source", (Object)"updates");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="local")
    public Object getLocal(@QueryParam(value="type") String type) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (type == null) {
            type = SharedPackageListingsSettings.instance().get("local").getPackageTypeFilter();
        }
        List pkgs = type == null || "".equals(type.trim()) ? pm.listLocalPackages() : pm.listLocalPackages(PackageType.getByValue((String)type));
        return this.getView("simpleListing").arg("pkgs", (Object)pkgs).arg("showCommunityInfo", (Object)false).arg("source", (Object)"local");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="remote")
    public Object getRemote(@QueryParam(value="type") String type, @QueryParam(value="onlyRemote") Boolean onlyRemote, @QueryParam(value="searchString") String searchString, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        boolean useSearch = true;
        if (type == null) {
            type = SharedPackageListingsSettings.instance().get("remote").getPackageTypeFilter();
        }
        if (filterOnPlatform == null) {
            filterOnPlatform = SharedPackageListingsSettings.instance().get("remote").getPlatformFilter();
        }
        if (onlyRemote == null) {
            onlyRemote = SharedPackageListingsSettings.instance().get("remote").isOnlyRemote();
        }
        if (searchString == null || "".equals(searchString)) {
            useSearch = false;
        }
        List pkgs = useSearch ? pm.searchPackages(searchString) : (!onlyRemote.booleanValue() ? (type == null || "".equals(type.trim()) ? pm.listRemoteOrLocalPackages() : pm.listRemoteOrLocalPackages(PackageType.getByValue((String)type))) : (type == null || "".equals(type.trim()) ? pm.listOnlyRemotePackages() : pm.listOnlyRemotePackages(PackageType.getByValue((String)type))));
        pkgs = this.filterOnPlatform(pkgs, filterOnPlatform);
        return this.getView("simpleListing").arg("pkgs", (Object)pkgs).arg("showCommunityInfo", (Object)false).arg("source", (Object)"remote");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="studio")
    public Object getStudio() {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        List pkgs = pm.listAllStudioRemoteOrLocalPackages();
        List<DownloadablePackage> pkgsWithoutSnapshot = StudioSnapshotHelper.removeSnapshot(pkgs);
        return this.getView("simpleListing").arg("pkgs", pkgsWithoutSnapshot).arg("showCommunityInfo", (Object)false).arg("source", (Object)"studio");
    }

    public String getStateLabel(Package pkg) {
        switch (pkg.getState()) {
            case 0: {
                return "remote";
            }
            case 2: {
                return "downloaded";
            }
            case 1: {
                DownloadingPackage dpkg = (DownloadingPackage)pkg;
                return "downloading (" + dpkg.getDownloadProgress() + "%)";
            }
            case 3: {
                return "installation in progress";
            }
            case 4: {
                return "installed";
            }
            case 5: {
                return "running";
            }
        }
        return "!?!";
    }

    public boolean canInstall(Package pkg) {
        return 2 == pkg.getState() && !InstallAfterRestart.isMarkedForInstallAfterRestart(pkg.getId());
    }

    public boolean needsRestart(Package pkg) {
        return InstallAfterRestart.isMarkedForInstallAfterRestart(pkg.getId()) || 4 == pkg.getState();
    }

    public boolean canUnInstall(Package pkg) {
        return 4 == pkg.getState() || 5 == pkg.getState();
    }

    public boolean canRemove(Package pkg) {
        return pkg.isLocal();
    }

    public boolean canDownload(Package pkg) {
        return 0 == pkg.getState() && (PackageType.STUDIO == pkg.getType() || ConnectStatusHolder.instance().isRegistred() && ConnectStatusHolder.instance().getStatus().status() == SubscriptionStatusType.OK);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="details/{pkgId}")
    public Object getDetails(@PathParam(value="pkgId") String pkgId) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        DownloadablePackage pkg = pm.getPackage(pkgId);
        if (pkg != null) {
            return this.getView("pkgDetails").arg("pkg", (Object)pkg);
        }
        return this.getView("pkgNotFound").arg("pkgId", (Object)pkgId);
    }
}

