/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import java.util.logging.Logger;

public class OfficeVersionDescriptor {
    protected String productName;
    protected String version;
    protected boolean useGnuStyleLongOptions = false;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public OfficeVersionDescriptor(String checkString) {
        String[] lines;
        this.logger.fine("Building " + this.getClass().getSimpleName() + ": " + checkString.trim());
        String productLine = null;
        for (String line : lines = checkString.split("\\n")) {
            String lowerLine;
            if (line.contains("--help")) {
                this.useGnuStyleLongOptions = true;
            }
            if (!(lowerLine = line.trim().toLowerCase()).startsWith("openoffice") && !lowerLine.startsWith("libreoffice")) continue;
            productLine = line.trim();
        }
        if (productLine != null) {
            String[] parts = productLine.split(" ");
            this.productName = parts.length > 0 ? parts[0] : "???";
            this.version = parts.length > 1 ? parts[1] : "???";
        } else {
            this.productName = "???";
            this.version = "???";
        }
        this.logger.info("soffice info: " + this.toString());
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean useGnuStyleLongOptions() {
        return this.useGnuStyleLongOptions;
    }

    public String toString() {
        return String.format("Product: %s - Version: %s - useGnuStyleLongOptions: %s", this.getProductName(), this.getVersion(), this.useGnuStyleLongOptions());
    }
}

