/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeTask;
import org.artofsolving.jodconverter.office.PooledOfficeManager;
import org.artofsolving.jodconverter.office.PooledOfficeManagerSettings;
import org.artofsolving.jodconverter.office.UnoUrl;
import org.artofsolving.jodconverter.process.ProcessManager;

class ProcessPoolOfficeManager
implements OfficeManager {
    private final BlockingQueue<PooledOfficeManager> pool;
    private final PooledOfficeManager[] pooledManagers;
    private final long taskQueueTimeout;
    private volatile boolean running = false;
    private final Logger logger = Logger.getLogger(ProcessPoolOfficeManager.class.getName());

    public ProcessPoolOfficeManager(File officeHome, UnoUrl[] unoUrls, File templateProfileDir, long taskQueueTimeout, long taskExecutionTimeout, int maxTasksPerProcess, ProcessManager processManager) {
        this(officeHome, unoUrls, templateProfileDir, taskQueueTimeout, taskExecutionTimeout, maxTasksPerProcess, processManager, false);
    }

    public ProcessPoolOfficeManager(File officeHome, UnoUrl[] unoUrls, File templateProfileDir, long taskQueueTimeout, long taskExecutionTimeout, int maxTasksPerProcess, ProcessManager processManager, boolean useGnuStyleLongOptions) {
        this.taskQueueTimeout = taskQueueTimeout;
        this.pool = new ArrayBlockingQueue<PooledOfficeManager>(unoUrls.length);
        this.pooledManagers = new PooledOfficeManager[unoUrls.length];
        for (int i = 0; i < unoUrls.length; ++i) {
            PooledOfficeManagerSettings settings = new PooledOfficeManagerSettings(unoUrls[i]);
            settings.setTemplateProfileDir(templateProfileDir);
            settings.setOfficeHome(officeHome);
            settings.setTaskExecutionTimeout(taskExecutionTimeout);
            settings.setMaxTasksPerProcess(maxTasksPerProcess);
            settings.setProcessManager(processManager);
            settings.setUseGnuStyleLongOptions(useGnuStyleLongOptions);
            this.pooledManagers[i] = new PooledOfficeManager(settings);
        }
        this.logger.info("ProcessManager implementation is " + processManager.getClass().getSimpleName());
    }

    public synchronized void start() throws OfficeException {
        for (int i = 0; i < this.pooledManagers.length; ++i) {
            this.pooledManagers[i].start();
            this.releaseManager(this.pooledManagers[i]);
        }
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeTask task) throws IllegalStateException, OfficeException {
        if (!this.running) {
            throw new IllegalStateException("this OfficeManager is currently stopped");
        }
        PooledOfficeManager manager = null;
        try {
            manager = this.acquireManager();
            if (manager == null) {
                throw new OfficeException("no office manager available");
            }
            manager.execute(task);
        }
        finally {
            if (manager != null) {
                this.releaseManager(manager);
            }
        }
    }

    public synchronized void stop() throws OfficeException {
        this.running = false;
        this.logger.info("stopping");
        this.pool.clear();
        for (int i = 0; i < this.pooledManagers.length; ++i) {
            this.pooledManagers[i].stop();
        }
        this.logger.info("stopped");
    }

    private PooledOfficeManager acquireManager() {
        try {
            return this.pool.poll(this.taskQueueTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new OfficeException("interrupted", interruptedException);
        }
    }

    private void releaseManager(PooledOfficeManager manager) {
        try {
            this.pool.put(manager);
        }
        catch (InterruptedException interruptedException) {
            throw new OfficeException("interrupted", interruptedException);
        }
    }
}

