/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ProcessInstance;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.dashboard.DocumentProcessItem;
import org.nuxeo.ecm.platform.jbpm.dashboard.DocumentProcessItemImpl;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.runtime.api.Framework;

public class UserProcessPageProvider
extends AbstractPageProvider<DocumentProcessItem>
implements PageProvider<DocumentProcessItem> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserProcessPageProvider.class);
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String FILTER_DOCS_FROM_TRASH = "filterDocumentsFromTrash";
    protected List<DocumentProcessItem> userProcesses;
    protected List<DocumentProcessItem> pageProcesses;

    public List<DocumentProcessItem> getCurrentPage() {
        if (this.pageProcesses == null) {
            this.pageProcesses = new ArrayList<DocumentProcessItem>();
            if (this.userProcesses == null) {
                this.getAllProcesses();
            }
            if (!this.hasError()) {
                int resultsCount = this.userProcesses.size();
                this.setResultsCount(resultsCount);
                long pageSize = this.getMinMaxPageSize();
                if (pageSize == 0L) {
                    this.pageProcesses.addAll(this.userProcesses);
                } else {
                    long offset = this.getCurrentPageOffset();
                    if (offset <= (long)resultsCount) {
                        for (int i = Long.valueOf(offset).intValue(); i < resultsCount && (long)i < offset + pageSize; ++i) {
                            this.pageProcesses.add(this.userProcesses.get(i));
                        }
                    }
                }
            }
        }
        return this.pageProcesses;
    }

    protected void getAllProcesses() {
        this.error = null;
        this.errorMessage = null;
        this.userProcesses = new ArrayList<DocumentProcessItem>();
        try {
            CoreSession coreSession = this.getCoreSession();
            boolean filterTrashDocs = this.getFilterDocumentsInTrash();
            NuxeoPrincipal pal = (NuxeoPrincipal)coreSession.getPrincipal();
            JbpmService jbpmService = (JbpmService)Framework.getService(JbpmService.class);
            List<ProcessInstance> processes = jbpmService.getCurrentProcessInstances(pal, null);
            if (processes != null) {
                for (ProcessInstance process : processes) {
                    try {
                        if (process.hasEnded()) continue;
                        DocumentModel doc = jbpmService.getDocumentModel(process, pal);
                        if (doc != null) {
                            if (filterTrashDocs && "deleted".equals(doc.getCurrentLifeCycleState())) continue;
                            this.userProcesses.add(new DocumentProcessItemImpl(process, doc));
                            continue;
                        }
                        log.warn((Object)String.format("User '%s' has a process of type '%s' on a missing or deleted document", pal.getName(), process.getProcessDefinition().getName()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.error = e;
            this.errorMessage = e.getMessage();
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean getFilterDocumentsInTrash() {
        Map props = this.getProperties();
        if (props.containsKey(FILTER_DOCS_FROM_TRASH)) {
            return Boolean.TRUE.equals(Boolean.valueOf((String)props.get(FILTER_DOCS_FROM_TRASH)));
        }
        return true;
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new ClientRuntimeException("cannot find core session");
        }
        return coreSession;
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        super.pageChanged();
        this.pageProcesses = null;
    }

    public void refresh() {
        super.refresh();
        this.userProcesses = null;
        this.pageProcesses = null;
    }
}

