/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.operation;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.DocumentRef;

public class Modification
implements Serializable {
    private static final long serialVersionUID = 9222943443571217778L;
    public static final int ADD_CHILD = 1;
    public static final int REMOVE_CHILD = 2;
    public static final int ORDER_CHILD = 4;
    public static final int CONTAINER_MODIFICATION = 7;
    public static final int CREATE = 8;
    public static final int REMOVE = 16;
    public static final int MOVE = 32;
    public static final int EXISTENCE_MODIFICATION = 56;
    public static final int CONTENT = 64;
    public static final int SECURITY = 128;
    public static final int STATE = 256;
    public static final int UPDATE_MODIFICATION = 448;
    public int type;
    public final DocumentRef ref;

    public Modification(DocumentRef ref, int type) {
        this.ref = ref;
        this.type = type;
    }

    public final boolean isUpdateModification() {
        return (this.type & 0x1C0) != 0;
    }

    public final boolean isContainerModification() {
        return (this.type & 7) != 0;
    }

    public final boolean isExistenceModification() {
        return (this.type & 0x38) != 0;
    }

    public final boolean isAddChild() {
        return (this.type & 1) != 0;
    }

    public final boolean isRemoveChild() {
        return (this.type & 2) != 0;
    }

    public final boolean isOrderChild() {
        return (this.type & 4) != 0;
    }

    public final boolean isCreate() {
        return (this.type & 8) != 0;
    }

    public final boolean isRemove() {
        return (this.type & 0x10) != 0;
    }

    public final boolean isContentUpdate() {
        return (this.type & 0x40) != 0;
    }

    public final boolean isStateUpdate() {
        return (this.type & 0x100) != 0;
    }

    public final boolean isSecurityUpdate() {
        return (this.type & 0x80) != 0;
    }

    public String toString() {
        return this.ref + " [" + this.type + ']';
    }
}

