/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.events.DocumentAttributeFilterFactory;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.Filter", category="Document", label="Filter List", description="Filter the input list of documents given a condition. The condition can be expressed using 4 parameters: types, facets, lifecycle and condition. If more than one parameter is specified an AND will be used to group conditions. <br>The 'types' paramter can take a comma separated list of document type: File,Note.<br>The 'facet' parameter can take a single facet name.<br> The 'life cycle' parameter takes a name of a life cycle state the document should have.<br>The 'condition' parameter can take any EL expression.<p>Returns the list of documents that match the filter condition.")
public class FilterDocuments {
    private static final Log log = LogFactory.getLog(FilterDocuments.class);
    public static final String ID = "Document.Filter";
    @Context
    protected OperationContext ctx;
    @Param(name="types", required=false)
    protected String types;
    @Param(name="facet", required=false)
    protected String facet;
    @Param(name="lifecycle", required=false)
    protected String lifeCycle;
    @Param(name="pathStartsWith", required=false)
    protected String pathStartsWith;
    @Param(name="condition", required=false)
    protected String condition;
    @Param(name="class", required=false, widget="Option", values={"Any", "Regular Document", "Document Link", "Published Document", "Document Proxy", "Document Version", "Immutable Document", "Mutable Document"})
    protected String attr;

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        Condition cond = new Condition();
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (!cond.accept(doc)) continue;
            result.add((Object)doc);
        }
        return result;
    }

    protected class Condition
    implements Filter {
        private static final long serialVersionUID = 1L;
        Set<String> types;
        String facet;
        String lc;
        Expression expr;
        Filter attr;

        Condition() {
            String v = FilterDocuments.this.types;
            if (v != null && (v = v.trim()).length() > 0) {
                this.types = new HashSet<String>();
                for (String t : StringUtils.split((String)v, (char)',', (boolean)true)) {
                    this.types.add(t);
                }
            }
            if ((v = FilterDocuments.this.facet) != null && (v = v.trim()).length() > 0) {
                this.facet = v;
            }
            if ((v = FilterDocuments.this.lifeCycle) != null && (v = v.trim()).length() > 0) {
                this.lc = v;
            }
            if ((v = FilterDocuments.this.condition) != null && (v = v.trim()).length() > 0) {
                this.expr = Scripting.newExpression(v);
            }
            if ((v = FilterDocuments.this.attr) != null) {
                this.attr = DocumentAttributeFilterFactory.getFilter(v);
            }
        }

        public boolean accept(DocumentModel doc) {
            if (this.types != null && !this.types.contains(doc.getType())) {
                return false;
            }
            if (this.facet != null && !doc.getFacets().contains(this.facet)) {
                return false;
            }
            if (this.lc != null) {
                try {
                    if (!this.lc.equals(doc.getCurrentLifeCycleState())) {
                        return false;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            if (this.attr != null && !this.attr.accept(doc)) {
                return false;
            }
            if (this.expr != null) {
                try {
                    if (!((Boolean)this.expr.eval(FilterDocuments.this.ctx)).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            return true;
        }
    }
}

