/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final boolean isMultipart;
    private Map<String, String[]> parameters;
    private String filename;
    private String contentType;
    private long size;
    private InputStream stream;

    public POSTHttpServletRequestWrapper(HttpServletRequest request) throws Exception {
        this(request, 0x400000);
    }

    public POSTHttpServletRequestWrapper(HttpServletRequest request, int memoryThreshold) throws Exception {
        super(request);
        this.isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (this.isMultipart) {
            String contentTypeControl;
            this.parameters = new HashMap<String, String[]>();
            DiskFileItemFactory itemFactory = new DiskFileItemFactory();
            itemFactory.setSizeThreshold(memoryThreshold);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)itemFactory);
            List fileItems = upload.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    String[] values = this.parameters.get(item.getFieldName());
                    if (values == null) {
                        this.parameters.put(item.getFieldName(), new String[]{item.getString()});
                        continue;
                    }
                    String[] newValues = new String[values.length + 1];
                    System.arraycopy(values, 0, newValues, 0, values.length);
                    newValues[newValues.length - 1] = item.getString();
                    this.parameters.put(item.getFieldName(), newValues);
                    continue;
                }
                this.filename = item.getName();
                this.contentType = item.getContentType() == null ? "application/octet-stream" : item.getContentType();
                this.size = item.getSize();
                this.stream = item.getInputStream();
            }
            String filenameControl = HttpUtils.getStringParameter((HttpServletRequest)this, "filename");
            if (filenameControl != null && filenameControl.trim().length() > 0) {
                this.filename = filenameControl;
            }
            if ((contentTypeControl = HttpUtils.getStringParameter((HttpServletRequest)this, "contenttype")) != null && contentTypeControl.trim().length() > 0) {
                this.contentType = contentTypeControl;
            }
        }
    }

    public String getParameter(String name) {
        if (!this.isMultipart) {
            return super.getParameter(name);
        }
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        if (!this.isMultipart) {
            return super.getParameterMap();
        }
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        if (!this.isMultipart) {
            return super.getParameterNames();
        }
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        if (!this.isMultipart) {
            return super.getParameterValues(name);
        }
        return this.parameters.get(name);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getStream() {
        return this.stream;
    }
}

