/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.InternalPackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.update.Version;

public class DependencyResolution {
    protected Boolean resolution = null;
    protected boolean sorted = false;
    protected String failedMessage;
    protected Map<String, Version> allPackages = new HashMap<String, Version>();
    protected Map<String, Version> newPackagesToDownload = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToInstall = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToUpgrade = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToRemove = new HashMap<String, Version>();
    protected Map<String, Version> localUnchangedPackages = new HashMap<String, Version>();
    protected List<String> orderedInstallablePackages = new ArrayList<String>();
    protected List<String> allPackagesToDownload = new ArrayList<String>();

    public DependencyResolution() {
    }

    public DependencyResolution(DependencyException ex) {
        this.markAsFailed();
        this.failedMessage = ex.getMessage();
    }

    public void markAsFailed() {
        this.resolution = false;
    }

    public void markAsSuccess() {
        this.resolution = true;
    }

    public boolean isValidated() {
        if (this.resolution == null) {
            return false;
        }
        return this.resolution;
    }

    public boolean isFailed() {
        if (this.resolution == null) {
            return false;
        }
        return this.resolution == false;
    }

    public boolean addPackage(String pkgName, Version v) {
        if (this.allPackages.containsKey(pkgName)) {
            if (!this.allPackages.get(pkgName).equals(v)) {
                this.resolution = false;
            }
        } else {
            this.allPackages.put(pkgName, v);
            this.orderedInstallablePackages.add(0, pkgName);
        }
        return !this.isFailed();
    }

    public void markPackageForRemoval(String pkgName, Version v) {
        this.localPackagesToRemove.put(pkgName, v);
    }

    public void sort(InternalPackageManager pm) {
        this.localPackagesToUpgrade.clear();
        this.newPackagesToDownload.clear();
        this.localPackagesToInstall.clear();
        this.localUnchangedPackages.clear();
        this.allPackagesToDownload.clear();
        for (String pkgName : this.allPackages.keySet()) {
            String id = pkgName + "-" + this.allPackages.get(pkgName).toString();
            DownloadablePackage pkg = pm.findPackageById(id);
            List<Version> existingVersions = pm.findLocalPackageInstalledVersions(pkg.getName());
            if (existingVersions.size() > 0 && !existingVersions.contains(pkg.getVersion())) {
                this.localPackagesToUpgrade.put(pkg.getName(), pkg.getVersion());
                if (pkg.getState() != 0) continue;
                this.allPackagesToDownload.add(id);
                continue;
            }
            if (pkg.getState() == 0) {
                this.newPackagesToDownload.put(pkg.getName(), pkg.getVersion());
                this.allPackagesToDownload.add(id);
                continue;
            }
            if (pkg.getState() > 0 && pkg.getState() < 3) {
                this.localPackagesToInstall.put(pkg.getName(), pkg.getVersion());
                continue;
            }
            if (pkg.getState() <= 3) continue;
            this.localUnchangedPackages.put(pkg.getName(), pkg.getVersion());
        }
        this.sorted = true;
    }

    public Map<String, Version> getNewPackagesToDownload() {
        return this.newPackagesToDownload;
    }

    public Map<String, Version> getLocalPackagesToInstall() {
        return this.localPackagesToInstall;
    }

    public Map<String, Version> getLocalPackagesToUpgrade() {
        return this.localPackagesToUpgrade;
    }

    public Map<String, Version> getLocalPackagesToRemove() {
        return this.localPackagesToRemove;
    }

    public Map<String, Version> getLocalUnchangedPackages() {
        return this.localUnchangedPackages;
    }

    public boolean requireChanges() {
        if (this.localPackagesToRemove.size() > 0) {
            return true;
        }
        if (this.localPackagesToUpgrade.size() > 0) {
            return true;
        }
        if (this.localPackagesToInstall.size() > 0) {
            return true;
        }
        return this.newPackagesToDownload.size() > 0;
    }

    public List<String> getInstallationOrder() {
        return this.orderedInstallablePackages;
    }

    public List<String> getUnchangedPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalUnchangedPackages().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getUpgradePackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToUpgrade().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getInstallPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToInstall().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getDownloadPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getNewPackagesToDownload().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getRemovePackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToRemove().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isFailed()) {
            sb.append("Failed to resolve dependencies : ");
            sb.append(this.failedMessage);
        } else if (!this.sorted) {
            for (String pkgName : this.allPackages.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(this.allPackages.get(pkgName).toString());
                sb.append(", ");
            }
        } else {
            sb.append("Packages to download: ");
            for (String pkgName : this.newPackagesToDownload.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(this.newPackagesToDownload.get(pkgName).toString());
                sb.append(", ");
            }
            sb.append("\nPackages to install (already in local): ");
            for (String pkgName : this.localPackagesToInstall.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(this.localPackagesToInstall.get(pkgName).toString());
                sb.append(", ");
            }
            sb.append("\nPackages to upgrade : ");
            for (String pkgName : this.localPackagesToUpgrade.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(this.localPackagesToUpgrade.get(pkgName).toString());
                sb.append(", ");
            }
            sb.append("\nUnchanged packages : ");
            for (String pkgName : this.localUnchangedPackages.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(this.localUnchangedPackages.get(pkgName).toString());
                sb.append(", ");
            }
            sb.append("\nLocal packages to remove: ");
            for (String pkgName : this.localPackagesToRemove.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(this.localPackagesToRemove.get(pkgName).toString());
                sb.append(", ");
            }
            sb.append("\nInstallation Order: ");
            sb.append(this.getInstallationOrderAsString());
        }
        return sb.toString();
    }

    public String getInstallationOrderAsString() {
        if (this.orderedInstallablePackages == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.orderedInstallablePackages.size(); ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(this.orderedInstallablePackages.get(i));
        }
        return sb.toString();
    }

    public List<String> getOrderedPackageIdsToInstall() {
        ArrayList<String> pkgIds = new ArrayList<String>();
        for (String pkgName : this.orderedInstallablePackages) {
            String pkgId = pkgName + "-" + this.allPackages.get(pkgName).toString();
            pkgIds.add(pkgId);
        }
        return pkgIds;
    }

    public String getAllPackagesToDownloadAsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.allPackagesToDownload.size(); ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(this.allPackagesToDownload.get(i));
        }
        return sb.toString();
    }

    public int getNbPackagesToDownload() {
        return this.allPackagesToDownload.size();
    }
}

