/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader.store;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.loader.store.ResourceStore;

public class MemoryStore
implements ResourceStore {
    protected final Map<String, byte[]> store;
    protected String location;

    public MemoryStore() {
        this(new HashMap<String, byte[]>());
    }

    public MemoryStore(Map<String, byte[]> store) {
        this.store = store;
        this.location = "java:" + System.identityHashCode(this);
    }

    @Override
    public boolean exists(String name) {
        return this.store.containsKey(name);
    }

    @Override
    public byte[] getBytes(String name) {
        return this.store.get(name);
    }

    @Override
    public InputStream getStream(String name) {
        byte[] data = this.store.get(name);
        return data == null ? null : new ByteArrayInputStream(data);
    }

    @Override
    public URL getURL(String name) {
        return null;
    }

    @Override
    public long lastModified(String name) {
        return 0L;
    }

    @Override
    public void put(String name, InputStream data) throws IOException {
        this.store.put(name, FileUtils.readBytes((InputStream)data));
    }

    @Override
    public void put(String name, byte[] data) throws IOException {
        this.store.put(name, data);
    }

    @Override
    public void remove(String name) {
        this.store.remove(name);
    }

    @Override
    public String getLocation() {
        return "java";
    }

    public String toString() {
        return this.getLocation();
    }
}

