/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.jboss;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.jboss.deployment.DeploymentInfo;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleManifestReader;

public class JBossBundleFile
implements BundleFile {
    private final DeploymentInfo di;

    public JBossBundleFile(DeploymentInfo di) {
        this.di = di;
    }

    protected DeploymentInfo getDeploymentInfo() {
        return this.di;
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        throw new UnsupportedOperationException("The operation Bundle.findEntries() was not yet implemented");
    }

    public ClassLoader getClassLoader() {
        return this.di.ucl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Cannot set the class loade rof a JBoss bundle deployment");
    }

    @Override
    public URL getEntry(String name) {
        return this.di.localCl.findResource(name);
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException("The operation Bundle.geEntryPaths() was not yet implemented");
    }

    @Override
    public String getLocation() {
        return this.di.url.toExternalForm();
    }

    @Override
    public Manifest getManifest() {
        return this.di.getManifest();
    }

    @Override
    public URL getURL() {
        return this.di.url;
    }

    @Override
    public File getFile() {
        return FileUtils.getFileFromURL((URL)this.di.url);
    }

    @Override
    public String getFileName() {
        return new File(this.di.url.getFile()).getName();
    }

    @Override
    public String getSymbolicName() {
        String value = this.di.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
        return value != null ? BundleManifestReader.removePropertiesFromHeaderValue(value) : null;
    }

    @Override
    public Collection<BundleFile> getNestedBundles(File tmpDir) throws IOException {
        return null;
    }

    @Override
    public Collection<BundleFile> findNestedBundles(File tmpDir) throws IOException {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return this.di.isDirectory;
    }

    @Override
    public boolean isJar() {
        return !this.di.isDirectory && !this.di.isXML && !this.di.isScript;
    }
}

