/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class MultiDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    private static final String NAME = "org.nuxeo.ecm.directory.multi.MultiDirectoryFactory";
    private static final Log log = LogFactory.getLog(MultiDirectoryFactory.class);
    private static DirectoryService directoryService;
    protected Map<String, MultiDirectory> directories;

    public Directory getDirectory(String name) {
        return (Directory)this.directories.get(name);
    }

    public String getName() {
        return NAME;
    }

    public void activate(ComponentContext context) {
        this.directories = new HashMap<String, MultiDirectory>();
    }

    public void deactivate(ComponentContext context) {
        this.directories = null;
    }

    public static DirectoryService getDirectoryService() {
        directoryService = (DirectoryService)Framework.getRuntime().getComponent(DirectoryService.NAME);
        if (directoryService == null && (directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class)) == null) {
            try {
                directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            }
            catch (Exception e) {
                log.error((Object)"Can't find Directory Service", (Throwable)e);
            }
        }
        return directoryService;
    }

    public void registerExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        DirectoryService dirService = MultiDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            MultiDirectoryDescriptor descriptor = (MultiDirectoryDescriptor)contrib;
            String name = descriptor.name;
            if (descriptor.remove) {
                log.info((Object)("Directory removed: " + name));
                this.directories.remove(name);
                dirService.unregisterDirectory(name, (DirectoryFactory)this);
                continue;
            }
            if (this.directories.containsKey(name)) {
                MultiDirectoryDescriptor previous = this.directories.get(name).getDescriptor();
                previous.merge(descriptor);
                log.info((Object)("Directory registration updated: " + name));
                continue;
            }
            MultiDirectory directory = new MultiDirectory(descriptor);
            this.directories.put(name, directory);
            dirService.registerDirectory(name, (DirectoryFactory)this);
            log.info((Object)("Directory registered: " + name));
        }
    }

    public void unregisterExtension(Extension extension) throws DirectoryException {
        Object[] contribs = extension.getContributions();
        DirectoryService dirService = MultiDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            MultiDirectoryDescriptor descriptor = (MultiDirectoryDescriptor)contrib;
            String directoryName = descriptor.name;
            dirService.unregisterDirectory(directoryName, (DirectoryFactory)this);
            this.directories.get(directoryName).shutdown();
            this.directories.remove(directoryName);
        }
    }

    public void shutdown() throws DirectoryException {
        for (MultiDirectory directory : this.directories.values()) {
            directory.shutdown();
        }
    }

    public List<Directory> getDirectories() {
        return new ArrayList<MultiDirectory>(this.directories.values());
    }
}

