/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.NameFormRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameFormRegistry
implements NameFormRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultNameFormRegistry.class);
    private final Map<String, NameForm> byOid = new HashMap<String, NameForm>();
    private final OidRegistry oidRegistry;

    public DefaultNameFormRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(NameForm nameForm) throws NamingException {
        if (this.byOid.containsKey(nameForm.getOid())) {
            NamingException e = new NamingException("nameForm w/ OID " + nameForm.getOid() + " has already been registered!");
            throw e;
        }
        this.oidRegistry.register(nameForm.getName(), nameForm.getOid());
        this.byOid.put(nameForm.getOid(), nameForm);
        if (log.isDebugEnabled()) {
            log.debug("registered nameForm: " + nameForm);
        }
    }

    @Override
    public NameForm lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("nameForm w/ OID " + id + " not registered!");
            throw e;
        }
        NameForm nameForm = this.byOid.get(id);
        if (log.isDebugEnabled()) {
            log.debug("lookup with id '" + id + "' of nameForm: " + nameForm);
        }
        return nameForm;
    }

    @Override
    public boolean hasNameForm(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        NameForm nf = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (nf != null) {
            return nf.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "NameForm map!");
    }

    @Override
    public Iterator<NameForm> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        this.byOid.remove(numericOid);
    }
}

