/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.milyn.assertion.AssertArgument;
import org.milyn.io.FileUtils;

public abstract class StreamUtils {
    public static byte[] readStream(InputStream stream) throws IOException {
        AssertArgument.isNotNull(stream, "stream");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] byteBuf = new byte[1024];
        int readCount = 0;
        while ((readCount = stream.read(byteBuf)) != -1) {
            bytesOut.write(byteBuf, 0, readCount);
        }
        return bytesOut.toByteArray();
    }

    public static String readStreamAsString(InputStream stream) throws IOException {
        AssertArgument.isNotNull(stream, "stream");
        return new String(StreamUtils.readStream(stream));
    }

    public static byte[] readFile(File file) throws IOException {
        return FileUtils.readFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] data) throws IOException {
        AssertArgument.isNotNull(file, "file");
        AssertArgument.isNotNull(data, "data");
        FileOutputStream stream = new FileOutputStream(file);
        try {
            ((OutputStream)stream).write(data);
        }
        finally {
            try {
                stream.flush();
            }
            finally {
                ((OutputStream)stream).close();
            }
        }
    }

    public static String readStream(Reader stream) throws IOException {
        AssertArgument.isNotNull(stream, "stream");
        StringBuffer streamString = new StringBuffer();
        char[] readBuffer = new char[256];
        int readCount = 0;
        while ((readCount = stream.read(readBuffer)) != -1) {
            streamString.append(readBuffer, 0, readCount);
        }
        return streamString.toString();
    }

    public static boolean compareCharStreams(InputStream s1, InputStream s2) {
        try {
            StringBuffer s1Buf = StreamUtils.trimLines(s1);
            StringBuffer s2Buf = StreamUtils.trimLines(s2);
            return s1Buf.toString().equals(s2Buf.toString());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean compareCharStreams(Reader s1, Reader s2) {
        try {
            StringBuffer s1Buf = StreamUtils.trimLines(s1);
            StringBuffer s2Buf = StreamUtils.trimLines(s2);
            return s1Buf.toString().equals(s2Buf.toString());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean compareCharStreams(String s1, String s2) {
        return StreamUtils.compareCharStreams(new StringReader(s1), new StringReader(s2));
    }

    public static StringBuffer trimLines(Reader charStream) throws IOException {
        String line;
        StringBuffer stringBuf = new StringBuffer();
        BufferedReader reader = new BufferedReader(charStream);
        while ((line = reader.readLine()) != null) {
            stringBuf.append(line.trim());
        }
        return stringBuf;
    }

    public static StringBuffer trimLines(InputStream charStream) throws IOException {
        return StreamUtils.trimLines(new InputStreamReader(charStream, "UTF-8"));
    }

    public static String trimLines(String charStream) throws IOException {
        return StreamUtils.trimLines(new StringReader(charStream)).toString();
    }
}

